
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.version.Info;
import io.fabric8.openshift.api.model.ConfigMapFileReference;
import io.fabric8.openshift.api.model.SecretNameReference;
import io.fabric8.openshift.api.model.operator.v1.Authentication;
import io.fabric8.openshift.api.model.operator.v1.AuthenticationList;
import io.fabric8.openshift.api.model.operator.v1.CSISnapshotController;
import io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerList;
import io.fabric8.openshift.api.model.operator.v1.Console;
import io.fabric8.openshift.api.model.operator.v1.ConsoleList;
import io.fabric8.openshift.api.model.operator.v1.DNS;
import io.fabric8.openshift.api.model.operator.v1.DNSList;
import io.fabric8.openshift.api.model.operator.v1.DNSRecord;
import io.fabric8.openshift.api.model.operator.v1.DNSRecordList;
import io.fabric8.openshift.api.model.operator.v1.Etcd;
import io.fabric8.openshift.api.model.operator.v1.EtcdList;
import io.fabric8.openshift.api.model.operator.v1.ImagePruner;
import io.fabric8.openshift.api.model.operator.v1.ImagePrunerList;
import io.fabric8.openshift.api.model.operator.v1.IngressController;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerList;
import io.fabric8.openshift.api.model.operator.v1.KubeAPIServer;
import io.fabric8.openshift.api.model.operator.v1.KubeAPIServerList;
import io.fabric8.openshift.api.model.operator.v1.KubeControllerManager;
import io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerList;
import io.fabric8.openshift.api.model.operator.v1.KubeScheduler;
import io.fabric8.openshift.api.model.operator.v1.KubeSchedulerList;
import io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator;
import io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorList;
import io.fabric8.openshift.api.model.operator.v1.Network;
import io.fabric8.openshift.api.model.operator.v1.NetworkList;
import io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer;
import io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerList;
import io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager;
import io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerList;
import io.fabric8.openshift.api.model.operator.v1.ServiceCA;
import io.fabric8.openshift.api.model.operator.v1.ServiceCAList;
import io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer;
import io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerList;
import io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager;
import io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerList;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyList;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "APIGroup",
    "APIGroupList",
    "Authentication",
    "AuthenticationList",
    "BaseKubernetesList",
    "CSISnapshotController",
    "CSISnapshotControllerList",
    "ConfigMapFileReference",
    "Console",
    "ConsoleList",
    "DNS",
    "DNSList",
    "DNSRecord",
    "DNSRecordList",
    "Etcd",
    "EtcdList",
    "ImageContentSourcePolicy",
    "ImageContentSourcePolicyList",
    "ImagePruner",
    "ImagePrunerList",
    "Info",
    "IngressController",
    "IngressControllerList",
    "KubeAPIServer",
    "KubeAPIServerList",
    "KubeControllerManager",
    "KubeControllerManagerList",
    "KubeScheduler",
    "KubeSchedulerList",
    "KubeStorageVersionMigrator",
    "KubeStorageVersionMigratorList",
    "Network",
    "NetworkList",
    "ObjectMeta",
    "OpenShiftAPIServer",
    "OpenShiftAPIServerList",
    "OpenShiftContollerManager",
    "OpenShiftControllerManagerList",
    "Patch",
    "Quantity",
    "SecretNameReference",
    "ServiceCA",
    "ServiceCAList",
    "ServiceCatalogAPIServer",
    "ServiceCatalogAPIServerList",
    "ServiceCatalogControllerManager",
    "ServiceCatalogControllerManagerList",
    "Status",
    "Time",
    "TypeMeta"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(io.fabric8.kubernetes.api.model.ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class KubeSchema {

    /**
     * 
     * 
     */
    @JsonProperty("APIGroup")
    private APIGroup aPIGroup;
    /**
     * 
     * 
     */
    @JsonProperty("APIGroupList")
    private APIGroupList aPIGroupList;
    /**
     * 
     * 
     */
    @JsonProperty("Authentication")
    private Authentication authentication;
    /**
     * 
     * 
     */
    @JsonProperty("AuthenticationList")
    private AuthenticationList authenticationList;
    /**
     * 
     * 
     */
    @JsonProperty("BaseKubernetesList")
    private BaseKubernetesList baseKubernetesList;
    /**
     * 
     * 
     */
    @JsonProperty("CSISnapshotController")
    private CSISnapshotController cSISnapshotController;
    /**
     * 
     * 
     */
    @JsonProperty("CSISnapshotControllerList")
    private CSISnapshotControllerList cSISnapshotControllerList;
    /**
     * 
     * 
     */
    @JsonProperty("ConfigMapFileReference")
    private ConfigMapFileReference configMapFileReference;
    /**
     * 
     * 
     */
    @JsonProperty("Console")
    private Console console;
    /**
     * 
     * 
     */
    @JsonProperty("ConsoleList")
    private ConsoleList consoleList;
    /**
     * 
     * 
     */
    @JsonProperty("DNS")
    private DNS dNS;
    /**
     * 
     * 
     */
    @JsonProperty("DNSList")
    private DNSList dNSList;
    /**
     * 
     * 
     */
    @JsonProperty("DNSRecord")
    private DNSRecord dNSRecord;
    /**
     * 
     * 
     */
    @JsonProperty("DNSRecordList")
    private DNSRecordList dNSRecordList;
    /**
     * 
     * 
     */
    @JsonProperty("Etcd")
    private Etcd etcd;
    /**
     * 
     * 
     */
    @JsonProperty("EtcdList")
    private EtcdList etcdList;
    /**
     * 
     * 
     */
    @JsonProperty("ImageContentSourcePolicy")
    private ImageContentSourcePolicy imageContentSourcePolicy;
    /**
     * 
     * 
     */
    @JsonProperty("ImageContentSourcePolicyList")
    private ImageContentSourcePolicyList imageContentSourcePolicyList;
    /**
     * 
     * 
     */
    @JsonProperty("ImagePruner")
    private ImagePruner imagePruner;
    /**
     * 
     * 
     */
    @JsonProperty("ImagePrunerList")
    private ImagePrunerList imagePrunerList;
    /**
     * 
     * 
     */
    @JsonProperty("Info")
    private Info info;
    /**
     * 
     * 
     */
    @JsonProperty("IngressController")
    private IngressController ingressController;
    /**
     * 
     * 
     */
    @JsonProperty("IngressControllerList")
    private IngressControllerList ingressControllerList;
    /**
     * 
     * 
     */
    @JsonProperty("KubeAPIServer")
    private KubeAPIServer kubeAPIServer;
    /**
     * 
     * 
     */
    @JsonProperty("KubeAPIServerList")
    private KubeAPIServerList kubeAPIServerList;
    /**
     * 
     * 
     */
    @JsonProperty("KubeControllerManager")
    private KubeControllerManager kubeControllerManager;
    /**
     * 
     * 
     */
    @JsonProperty("KubeControllerManagerList")
    private KubeControllerManagerList kubeControllerManagerList;
    /**
     * 
     * 
     */
    @JsonProperty("KubeScheduler")
    private KubeScheduler kubeScheduler;
    /**
     * 
     * 
     */
    @JsonProperty("KubeSchedulerList")
    private KubeSchedulerList kubeSchedulerList;
    /**
     * 
     * 
     */
    @JsonProperty("KubeStorageVersionMigrator")
    private KubeStorageVersionMigrator kubeStorageVersionMigrator;
    /**
     * 
     * 
     */
    @JsonProperty("KubeStorageVersionMigratorList")
    private KubeStorageVersionMigratorList kubeStorageVersionMigratorList;
    /**
     * 
     * 
     */
    @JsonProperty("Network")
    private Network network;
    /**
     * 
     * 
     */
    @JsonProperty("NetworkList")
    private NetworkList networkList;
    /**
     * 
     * 
     */
    @JsonProperty("ObjectMeta")
    private io.fabric8.kubernetes.api.model.ObjectMeta objectMeta;
    /**
     * 
     * 
     */
    @JsonProperty("OpenShiftAPIServer")
    private OpenShiftAPIServer openShiftAPIServer;
    /**
     * 
     * 
     */
    @JsonProperty("OpenShiftAPIServerList")
    private OpenShiftAPIServerList openShiftAPIServerList;
    /**
     * 
     * 
     */
    @JsonProperty("OpenShiftContollerManager")
    private OpenShiftControllerManager openShiftContollerManager;
    /**
     * 
     * 
     */
    @JsonProperty("OpenShiftControllerManagerList")
    private OpenShiftControllerManagerList openShiftControllerManagerList;
    /**
     * 
     * 
     */
    @JsonProperty("Patch")
    private Patch patch;
    /**
     * 
     * 
     */
    @JsonProperty("Quantity")
    private Quantity quantity;
    /**
     * 
     * 
     */
    @JsonProperty("SecretNameReference")
    private SecretNameReference secretNameReference;
    /**
     * 
     * 
     */
    @JsonProperty("ServiceCA")
    private ServiceCA serviceCA;
    /**
     * 
     * 
     */
    @JsonProperty("ServiceCAList")
    private ServiceCAList serviceCAList;
    /**
     * 
     * 
     */
    @JsonProperty("ServiceCatalogAPIServer")
    private ServiceCatalogAPIServer serviceCatalogAPIServer;
    /**
     * 
     * 
     */
    @JsonProperty("ServiceCatalogAPIServerList")
    private ServiceCatalogAPIServerList serviceCatalogAPIServerList;
    /**
     * 
     * 
     */
    @JsonProperty("ServiceCatalogControllerManager")
    private ServiceCatalogControllerManager serviceCatalogControllerManager;
    /**
     * 
     * 
     */
    @JsonProperty("ServiceCatalogControllerManagerList")
    private ServiceCatalogControllerManagerList serviceCatalogControllerManagerList;
    /**
     * 
     * 
     */
    @JsonProperty("Status")
    private Status status;
    /**
     * 
     * 
     */
    @JsonProperty("Time")
    private String time;
    /**
     * 
     * 
     */
    @JsonProperty("TypeMeta")
    private TypeMeta typeMeta;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public KubeSchema() {
    }

    /**
     * 
     * @param secretNameReference
     * @param aPIGroupList
     * @param kubeControllerManager
     * @param cSISnapshotControllerList
     * @param serviceCatalogControllerManager
     * @param dNSRecordList
     * @param kubeSchedulerList
     * @param authenticationList
     * @param patch
     * @param ingressControllerList
     * @param kubeAPIServer
     * @param openShiftAPIServer
     * @param info
     * @param openShiftContollerManager
     * @param kubeStorageVersionMigratorList
     * @param dNS
     * @param imagePruner
     * @param kubeAPIServerList
     * @param etcdList
     * @param configMapFileReference
     * @param kubeControllerManagerList
     * @param serviceCAList
     * @param networkList
     * @param openShiftAPIServerList
     * @param consoleList
     * @param serviceCA
     * @param status
     * @param ingressController
     * @param serviceCatalogAPIServer
     * @param baseKubernetesList
     * @param cSISnapshotController
     * @param imageContentSourcePolicyList
     * @param imagePrunerList
     * @param network
     * @param serviceCatalogControllerManagerList
     * @param kubeScheduler
     * @param dNSList
     * @param kubeStorageVersionMigrator
     * @param authentication
     * @param console
     * @param quantity
     * @param imageContentSourcePolicy
     * @param aPIGroup
     * @param typeMeta
     * @param objectMeta
     * @param serviceCatalogAPIServerList
     * @param time
     * @param dNSRecord
     * @param openShiftControllerManagerList
     * @param etcd
     */
    public KubeSchema(APIGroup aPIGroup, APIGroupList aPIGroupList, Authentication authentication, AuthenticationList authenticationList, BaseKubernetesList baseKubernetesList, CSISnapshotController cSISnapshotController, CSISnapshotControllerList cSISnapshotControllerList, ConfigMapFileReference configMapFileReference, Console console, ConsoleList consoleList, DNS dNS, DNSList dNSList, DNSRecord dNSRecord, DNSRecordList dNSRecordList, Etcd etcd, EtcdList etcdList, ImageContentSourcePolicy imageContentSourcePolicy, ImageContentSourcePolicyList imageContentSourcePolicyList, ImagePruner imagePruner, ImagePrunerList imagePrunerList, Info info, IngressController ingressController, IngressControllerList ingressControllerList, KubeAPIServer kubeAPIServer, KubeAPIServerList kubeAPIServerList, KubeControllerManager kubeControllerManager, KubeControllerManagerList kubeControllerManagerList, KubeScheduler kubeScheduler, KubeSchedulerList kubeSchedulerList, KubeStorageVersionMigrator kubeStorageVersionMigrator, KubeStorageVersionMigratorList kubeStorageVersionMigratorList, Network network, NetworkList networkList, io.fabric8.kubernetes.api.model.ObjectMeta objectMeta, OpenShiftAPIServer openShiftAPIServer, OpenShiftAPIServerList openShiftAPIServerList, OpenShiftControllerManager openShiftContollerManager, OpenShiftControllerManagerList openShiftControllerManagerList, Patch patch, Quantity quantity, SecretNameReference secretNameReference, ServiceCA serviceCA, ServiceCAList serviceCAList, ServiceCatalogAPIServer serviceCatalogAPIServer, ServiceCatalogAPIServerList serviceCatalogAPIServerList, ServiceCatalogControllerManager serviceCatalogControllerManager, ServiceCatalogControllerManagerList serviceCatalogControllerManagerList, Status status, String time, TypeMeta typeMeta) {
        this.aPIGroup = aPIGroup;
        this.aPIGroupList = aPIGroupList;
        this.authentication = authentication;
        this.authenticationList = authenticationList;
        this.baseKubernetesList = baseKubernetesList;
        this.cSISnapshotController = cSISnapshotController;
        this.cSISnapshotControllerList = cSISnapshotControllerList;
        this.configMapFileReference = configMapFileReference;
        this.console = console;
        this.consoleList = consoleList;
        this.dNS = dNS;
        this.dNSList = dNSList;
        this.dNSRecord = dNSRecord;
        this.dNSRecordList = dNSRecordList;
        this.etcd = etcd;
        this.etcdList = etcdList;
        this.imageContentSourcePolicy = imageContentSourcePolicy;
        this.imageContentSourcePolicyList = imageContentSourcePolicyList;
        this.imagePruner = imagePruner;
        this.imagePrunerList = imagePrunerList;
        this.info = info;
        this.ingressController = ingressController;
        this.ingressControllerList = ingressControllerList;
        this.kubeAPIServer = kubeAPIServer;
        this.kubeAPIServerList = kubeAPIServerList;
        this.kubeControllerManager = kubeControllerManager;
        this.kubeControllerManagerList = kubeControllerManagerList;
        this.kubeScheduler = kubeScheduler;
        this.kubeSchedulerList = kubeSchedulerList;
        this.kubeStorageVersionMigrator = kubeStorageVersionMigrator;
        this.kubeStorageVersionMigratorList = kubeStorageVersionMigratorList;
        this.network = network;
        this.networkList = networkList;
        this.objectMeta = objectMeta;
        this.openShiftAPIServer = openShiftAPIServer;
        this.openShiftAPIServerList = openShiftAPIServerList;
        this.openShiftContollerManager = openShiftContollerManager;
        this.openShiftControllerManagerList = openShiftControllerManagerList;
        this.patch = patch;
        this.quantity = quantity;
        this.secretNameReference = secretNameReference;
        this.serviceCA = serviceCA;
        this.serviceCAList = serviceCAList;
        this.serviceCatalogAPIServer = serviceCatalogAPIServer;
        this.serviceCatalogAPIServerList = serviceCatalogAPIServerList;
        this.serviceCatalogControllerManager = serviceCatalogControllerManager;
        this.serviceCatalogControllerManagerList = serviceCatalogControllerManagerList;
        this.status = status;
        this.time = time;
        this.typeMeta = typeMeta;
    }

    /**
     * 
     * 
     * @return
     *     The aPIGroup
     */
    @JsonProperty("APIGroup")
    public APIGroup getAPIGroup() {
        return aPIGroup;
    }

    /**
     * 
     * 
     * @param aPIGroup
     *     The APIGroup
     */
    @JsonProperty("APIGroup")
    public void setAPIGroup(APIGroup aPIGroup) {
        this.aPIGroup = aPIGroup;
    }

    /**
     * 
     * 
     * @return
     *     The aPIGroupList
     */
    @JsonProperty("APIGroupList")
    public APIGroupList getAPIGroupList() {
        return aPIGroupList;
    }

    /**
     * 
     * 
     * @param aPIGroupList
     *     The APIGroupList
     */
    @JsonProperty("APIGroupList")
    public void setAPIGroupList(APIGroupList aPIGroupList) {
        this.aPIGroupList = aPIGroupList;
    }

    /**
     * 
     * 
     * @return
     *     The authentication
     */
    @JsonProperty("Authentication")
    public Authentication getAuthentication() {
        return authentication;
    }

    /**
     * 
     * 
     * @param authentication
     *     The Authentication
     */
    @JsonProperty("Authentication")
    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    /**
     * 
     * 
     * @return
     *     The authenticationList
     */
    @JsonProperty("AuthenticationList")
    public AuthenticationList getAuthenticationList() {
        return authenticationList;
    }

    /**
     * 
     * 
     * @param authenticationList
     *     The AuthenticationList
     */
    @JsonProperty("AuthenticationList")
    public void setAuthenticationList(AuthenticationList authenticationList) {
        this.authenticationList = authenticationList;
    }

    /**
     * 
     * 
     * @return
     *     The baseKubernetesList
     */
    @JsonProperty("BaseKubernetesList")
    public BaseKubernetesList getBaseKubernetesList() {
        return baseKubernetesList;
    }

    /**
     * 
     * 
     * @param baseKubernetesList
     *     The BaseKubernetesList
     */
    @JsonProperty("BaseKubernetesList")
    public void setBaseKubernetesList(BaseKubernetesList baseKubernetesList) {
        this.baseKubernetesList = baseKubernetesList;
    }

    /**
     * 
     * 
     * @return
     *     The cSISnapshotController
     */
    @JsonProperty("CSISnapshotController")
    public CSISnapshotController getCSISnapshotController() {
        return cSISnapshotController;
    }

    /**
     * 
     * 
     * @param cSISnapshotController
     *     The CSISnapshotController
     */
    @JsonProperty("CSISnapshotController")
    public void setCSISnapshotController(CSISnapshotController cSISnapshotController) {
        this.cSISnapshotController = cSISnapshotController;
    }

    /**
     * 
     * 
     * @return
     *     The cSISnapshotControllerList
     */
    @JsonProperty("CSISnapshotControllerList")
    public CSISnapshotControllerList getCSISnapshotControllerList() {
        return cSISnapshotControllerList;
    }

    /**
     * 
     * 
     * @param cSISnapshotControllerList
     *     The CSISnapshotControllerList
     */
    @JsonProperty("CSISnapshotControllerList")
    public void setCSISnapshotControllerList(CSISnapshotControllerList cSISnapshotControllerList) {
        this.cSISnapshotControllerList = cSISnapshotControllerList;
    }

    /**
     * 
     * 
     * @return
     *     The configMapFileReference
     */
    @JsonProperty("ConfigMapFileReference")
    public ConfigMapFileReference getConfigMapFileReference() {
        return configMapFileReference;
    }

    /**
     * 
     * 
     * @param configMapFileReference
     *     The ConfigMapFileReference
     */
    @JsonProperty("ConfigMapFileReference")
    public void setConfigMapFileReference(ConfigMapFileReference configMapFileReference) {
        this.configMapFileReference = configMapFileReference;
    }

    /**
     * 
     * 
     * @return
     *     The console
     */
    @JsonProperty("Console")
    public Console getConsole() {
        return console;
    }

    /**
     * 
     * 
     * @param console
     *     The Console
     */
    @JsonProperty("Console")
    public void setConsole(Console console) {
        this.console = console;
    }

    /**
     * 
     * 
     * @return
     *     The consoleList
     */
    @JsonProperty("ConsoleList")
    public ConsoleList getConsoleList() {
        return consoleList;
    }

    /**
     * 
     * 
     * @param consoleList
     *     The ConsoleList
     */
    @JsonProperty("ConsoleList")
    public void setConsoleList(ConsoleList consoleList) {
        this.consoleList = consoleList;
    }

    /**
     * 
     * 
     * @return
     *     The dNS
     */
    @JsonProperty("DNS")
    public DNS getDNS() {
        return dNS;
    }

    /**
     * 
     * 
     * @param dNS
     *     The DNS
     */
    @JsonProperty("DNS")
    public void setDNS(DNS dNS) {
        this.dNS = dNS;
    }

    /**
     * 
     * 
     * @return
     *     The dNSList
     */
    @JsonProperty("DNSList")
    public DNSList getDNSList() {
        return dNSList;
    }

    /**
     * 
     * 
     * @param dNSList
     *     The DNSList
     */
    @JsonProperty("DNSList")
    public void setDNSList(DNSList dNSList) {
        this.dNSList = dNSList;
    }

    /**
     * 
     * 
     * @return
     *     The dNSRecord
     */
    @JsonProperty("DNSRecord")
    public DNSRecord getDNSRecord() {
        return dNSRecord;
    }

    /**
     * 
     * 
     * @param dNSRecord
     *     The DNSRecord
     */
    @JsonProperty("DNSRecord")
    public void setDNSRecord(DNSRecord dNSRecord) {
        this.dNSRecord = dNSRecord;
    }

    /**
     * 
     * 
     * @return
     *     The dNSRecordList
     */
    @JsonProperty("DNSRecordList")
    public DNSRecordList getDNSRecordList() {
        return dNSRecordList;
    }

    /**
     * 
     * 
     * @param dNSRecordList
     *     The DNSRecordList
     */
    @JsonProperty("DNSRecordList")
    public void setDNSRecordList(DNSRecordList dNSRecordList) {
        this.dNSRecordList = dNSRecordList;
    }

    /**
     * 
     * 
     * @return
     *     The etcd
     */
    @JsonProperty("Etcd")
    public Etcd getEtcd() {
        return etcd;
    }

    /**
     * 
     * 
     * @param etcd
     *     The Etcd
     */
    @JsonProperty("Etcd")
    public void setEtcd(Etcd etcd) {
        this.etcd = etcd;
    }

    /**
     * 
     * 
     * @return
     *     The etcdList
     */
    @JsonProperty("EtcdList")
    public EtcdList getEtcdList() {
        return etcdList;
    }

    /**
     * 
     * 
     * @param etcdList
     *     The EtcdList
     */
    @JsonProperty("EtcdList")
    public void setEtcdList(EtcdList etcdList) {
        this.etcdList = etcdList;
    }

    /**
     * 
     * 
     * @return
     *     The imageContentSourcePolicy
     */
    @JsonProperty("ImageContentSourcePolicy")
    public ImageContentSourcePolicy getImageContentSourcePolicy() {
        return imageContentSourcePolicy;
    }

    /**
     * 
     * 
     * @param imageContentSourcePolicy
     *     The ImageContentSourcePolicy
     */
    @JsonProperty("ImageContentSourcePolicy")
    public void setImageContentSourcePolicy(ImageContentSourcePolicy imageContentSourcePolicy) {
        this.imageContentSourcePolicy = imageContentSourcePolicy;
    }

    /**
     * 
     * 
     * @return
     *     The imageContentSourcePolicyList
     */
    @JsonProperty("ImageContentSourcePolicyList")
    public ImageContentSourcePolicyList getImageContentSourcePolicyList() {
        return imageContentSourcePolicyList;
    }

    /**
     * 
     * 
     * @param imageContentSourcePolicyList
     *     The ImageContentSourcePolicyList
     */
    @JsonProperty("ImageContentSourcePolicyList")
    public void setImageContentSourcePolicyList(ImageContentSourcePolicyList imageContentSourcePolicyList) {
        this.imageContentSourcePolicyList = imageContentSourcePolicyList;
    }

    /**
     * 
     * 
     * @return
     *     The imagePruner
     */
    @JsonProperty("ImagePruner")
    public ImagePruner getImagePruner() {
        return imagePruner;
    }

    /**
     * 
     * 
     * @param imagePruner
     *     The ImagePruner
     */
    @JsonProperty("ImagePruner")
    public void setImagePruner(ImagePruner imagePruner) {
        this.imagePruner = imagePruner;
    }

    /**
     * 
     * 
     * @return
     *     The imagePrunerList
     */
    @JsonProperty("ImagePrunerList")
    public ImagePrunerList getImagePrunerList() {
        return imagePrunerList;
    }

    /**
     * 
     * 
     * @param imagePrunerList
     *     The ImagePrunerList
     */
    @JsonProperty("ImagePrunerList")
    public void setImagePrunerList(ImagePrunerList imagePrunerList) {
        this.imagePrunerList = imagePrunerList;
    }

    /**
     * 
     * 
     * @return
     *     The info
     */
    @JsonProperty("Info")
    public Info getInfo() {
        return info;
    }

    /**
     * 
     * 
     * @param info
     *     The Info
     */
    @JsonProperty("Info")
    public void setInfo(Info info) {
        this.info = info;
    }

    /**
     * 
     * 
     * @return
     *     The ingressController
     */
    @JsonProperty("IngressController")
    public IngressController getIngressController() {
        return ingressController;
    }

    /**
     * 
     * 
     * @param ingressController
     *     The IngressController
     */
    @JsonProperty("IngressController")
    public void setIngressController(IngressController ingressController) {
        this.ingressController = ingressController;
    }

    /**
     * 
     * 
     * @return
     *     The ingressControllerList
     */
    @JsonProperty("IngressControllerList")
    public IngressControllerList getIngressControllerList() {
        return ingressControllerList;
    }

    /**
     * 
     * 
     * @param ingressControllerList
     *     The IngressControllerList
     */
    @JsonProperty("IngressControllerList")
    public void setIngressControllerList(IngressControllerList ingressControllerList) {
        this.ingressControllerList = ingressControllerList;
    }

    /**
     * 
     * 
     * @return
     *     The kubeAPIServer
     */
    @JsonProperty("KubeAPIServer")
    public KubeAPIServer getKubeAPIServer() {
        return kubeAPIServer;
    }

    /**
     * 
     * 
     * @param kubeAPIServer
     *     The KubeAPIServer
     */
    @JsonProperty("KubeAPIServer")
    public void setKubeAPIServer(KubeAPIServer kubeAPIServer) {
        this.kubeAPIServer = kubeAPIServer;
    }

    /**
     * 
     * 
     * @return
     *     The kubeAPIServerList
     */
    @JsonProperty("KubeAPIServerList")
    public KubeAPIServerList getKubeAPIServerList() {
        return kubeAPIServerList;
    }

    /**
     * 
     * 
     * @param kubeAPIServerList
     *     The KubeAPIServerList
     */
    @JsonProperty("KubeAPIServerList")
    public void setKubeAPIServerList(KubeAPIServerList kubeAPIServerList) {
        this.kubeAPIServerList = kubeAPIServerList;
    }

    /**
     * 
     * 
     * @return
     *     The kubeControllerManager
     */
    @JsonProperty("KubeControllerManager")
    public KubeControllerManager getKubeControllerManager() {
        return kubeControllerManager;
    }

    /**
     * 
     * 
     * @param kubeControllerManager
     *     The KubeControllerManager
     */
    @JsonProperty("KubeControllerManager")
    public void setKubeControllerManager(KubeControllerManager kubeControllerManager) {
        this.kubeControllerManager = kubeControllerManager;
    }

    /**
     * 
     * 
     * @return
     *     The kubeControllerManagerList
     */
    @JsonProperty("KubeControllerManagerList")
    public KubeControllerManagerList getKubeControllerManagerList() {
        return kubeControllerManagerList;
    }

    /**
     * 
     * 
     * @param kubeControllerManagerList
     *     The KubeControllerManagerList
     */
    @JsonProperty("KubeControllerManagerList")
    public void setKubeControllerManagerList(KubeControllerManagerList kubeControllerManagerList) {
        this.kubeControllerManagerList = kubeControllerManagerList;
    }

    /**
     * 
     * 
     * @return
     *     The kubeScheduler
     */
    @JsonProperty("KubeScheduler")
    public KubeScheduler getKubeScheduler() {
        return kubeScheduler;
    }

    /**
     * 
     * 
     * @param kubeScheduler
     *     The KubeScheduler
     */
    @JsonProperty("KubeScheduler")
    public void setKubeScheduler(KubeScheduler kubeScheduler) {
        this.kubeScheduler = kubeScheduler;
    }

    /**
     * 
     * 
     * @return
     *     The kubeSchedulerList
     */
    @JsonProperty("KubeSchedulerList")
    public KubeSchedulerList getKubeSchedulerList() {
        return kubeSchedulerList;
    }

    /**
     * 
     * 
     * @param kubeSchedulerList
     *     The KubeSchedulerList
     */
    @JsonProperty("KubeSchedulerList")
    public void setKubeSchedulerList(KubeSchedulerList kubeSchedulerList) {
        this.kubeSchedulerList = kubeSchedulerList;
    }

    /**
     * 
     * 
     * @return
     *     The kubeStorageVersionMigrator
     */
    @JsonProperty("KubeStorageVersionMigrator")
    public KubeStorageVersionMigrator getKubeStorageVersionMigrator() {
        return kubeStorageVersionMigrator;
    }

    /**
     * 
     * 
     * @param kubeStorageVersionMigrator
     *     The KubeStorageVersionMigrator
     */
    @JsonProperty("KubeStorageVersionMigrator")
    public void setKubeStorageVersionMigrator(KubeStorageVersionMigrator kubeStorageVersionMigrator) {
        this.kubeStorageVersionMigrator = kubeStorageVersionMigrator;
    }

    /**
     * 
     * 
     * @return
     *     The kubeStorageVersionMigratorList
     */
    @JsonProperty("KubeStorageVersionMigratorList")
    public KubeStorageVersionMigratorList getKubeStorageVersionMigratorList() {
        return kubeStorageVersionMigratorList;
    }

    /**
     * 
     * 
     * @param kubeStorageVersionMigratorList
     *     The KubeStorageVersionMigratorList
     */
    @JsonProperty("KubeStorageVersionMigratorList")
    public void setKubeStorageVersionMigratorList(KubeStorageVersionMigratorList kubeStorageVersionMigratorList) {
        this.kubeStorageVersionMigratorList = kubeStorageVersionMigratorList;
    }

    /**
     * 
     * 
     * @return
     *     The network
     */
    @JsonProperty("Network")
    public Network getNetwork() {
        return network;
    }

    /**
     * 
     * 
     * @param network
     *     The Network
     */
    @JsonProperty("Network")
    public void setNetwork(Network network) {
        this.network = network;
    }

    /**
     * 
     * 
     * @return
     *     The networkList
     */
    @JsonProperty("NetworkList")
    public NetworkList getNetworkList() {
        return networkList;
    }

    /**
     * 
     * 
     * @param networkList
     *     The NetworkList
     */
    @JsonProperty("NetworkList")
    public void setNetworkList(NetworkList networkList) {
        this.networkList = networkList;
    }

    /**
     * 
     * 
     * @return
     *     The objectMeta
     */
    @JsonProperty("ObjectMeta")
    public io.fabric8.kubernetes.api.model.ObjectMeta getObjectMeta() {
        return objectMeta;
    }

    /**
     * 
     * 
     * @param objectMeta
     *     The ObjectMeta
     */
    @JsonProperty("ObjectMeta")
    public void setObjectMeta(io.fabric8.kubernetes.api.model.ObjectMeta objectMeta) {
        this.objectMeta = objectMeta;
    }

    /**
     * 
     * 
     * @return
     *     The openShiftAPIServer
     */
    @JsonProperty("OpenShiftAPIServer")
    public OpenShiftAPIServer getOpenShiftAPIServer() {
        return openShiftAPIServer;
    }

    /**
     * 
     * 
     * @param openShiftAPIServer
     *     The OpenShiftAPIServer
     */
    @JsonProperty("OpenShiftAPIServer")
    public void setOpenShiftAPIServer(OpenShiftAPIServer openShiftAPIServer) {
        this.openShiftAPIServer = openShiftAPIServer;
    }

    /**
     * 
     * 
     * @return
     *     The openShiftAPIServerList
     */
    @JsonProperty("OpenShiftAPIServerList")
    public OpenShiftAPIServerList getOpenShiftAPIServerList() {
        return openShiftAPIServerList;
    }

    /**
     * 
     * 
     * @param openShiftAPIServerList
     *     The OpenShiftAPIServerList
     */
    @JsonProperty("OpenShiftAPIServerList")
    public void setOpenShiftAPIServerList(OpenShiftAPIServerList openShiftAPIServerList) {
        this.openShiftAPIServerList = openShiftAPIServerList;
    }

    /**
     * 
     * 
     * @return
     *     The openShiftContollerManager
     */
    @JsonProperty("OpenShiftContollerManager")
    public OpenShiftControllerManager getOpenShiftContollerManager() {
        return openShiftContollerManager;
    }

    /**
     * 
     * 
     * @param openShiftContollerManager
     *     The OpenShiftContollerManager
     */
    @JsonProperty("OpenShiftContollerManager")
    public void setOpenShiftContollerManager(OpenShiftControllerManager openShiftContollerManager) {
        this.openShiftContollerManager = openShiftContollerManager;
    }

    /**
     * 
     * 
     * @return
     *     The openShiftControllerManagerList
     */
    @JsonProperty("OpenShiftControllerManagerList")
    public OpenShiftControllerManagerList getOpenShiftControllerManagerList() {
        return openShiftControllerManagerList;
    }

    /**
     * 
     * 
     * @param openShiftControllerManagerList
     *     The OpenShiftControllerManagerList
     */
    @JsonProperty("OpenShiftControllerManagerList")
    public void setOpenShiftControllerManagerList(OpenShiftControllerManagerList openShiftControllerManagerList) {
        this.openShiftControllerManagerList = openShiftControllerManagerList;
    }

    /**
     * 
     * 
     * @return
     *     The patch
     */
    @JsonProperty("Patch")
    public Patch getPatch() {
        return patch;
    }

    /**
     * 
     * 
     * @param patch
     *     The Patch
     */
    @JsonProperty("Patch")
    public void setPatch(Patch patch) {
        this.patch = patch;
    }

    /**
     * 
     * 
     * @return
     *     The quantity
     */
    @JsonProperty("Quantity")
    public Quantity getQuantity() {
        return quantity;
    }

    /**
     * 
     * 
     * @param quantity
     *     The Quantity
     */
    @JsonProperty("Quantity")
    public void setQuantity(Quantity quantity) {
        this.quantity = quantity;
    }

    /**
     * 
     * 
     * @return
     *     The secretNameReference
     */
    @JsonProperty("SecretNameReference")
    public SecretNameReference getSecretNameReference() {
        return secretNameReference;
    }

    /**
     * 
     * 
     * @param secretNameReference
     *     The SecretNameReference
     */
    @JsonProperty("SecretNameReference")
    public void setSecretNameReference(SecretNameReference secretNameReference) {
        this.secretNameReference = secretNameReference;
    }

    /**
     * 
     * 
     * @return
     *     The serviceCA
     */
    @JsonProperty("ServiceCA")
    public ServiceCA getServiceCA() {
        return serviceCA;
    }

    /**
     * 
     * 
     * @param serviceCA
     *     The ServiceCA
     */
    @JsonProperty("ServiceCA")
    public void setServiceCA(ServiceCA serviceCA) {
        this.serviceCA = serviceCA;
    }

    /**
     * 
     * 
     * @return
     *     The serviceCAList
     */
    @JsonProperty("ServiceCAList")
    public ServiceCAList getServiceCAList() {
        return serviceCAList;
    }

    /**
     * 
     * 
     * @param serviceCAList
     *     The ServiceCAList
     */
    @JsonProperty("ServiceCAList")
    public void setServiceCAList(ServiceCAList serviceCAList) {
        this.serviceCAList = serviceCAList;
    }

    /**
     * 
     * 
     * @return
     *     The serviceCatalogAPIServer
     */
    @JsonProperty("ServiceCatalogAPIServer")
    public ServiceCatalogAPIServer getServiceCatalogAPIServer() {
        return serviceCatalogAPIServer;
    }

    /**
     * 
     * 
     * @param serviceCatalogAPIServer
     *     The ServiceCatalogAPIServer
     */
    @JsonProperty("ServiceCatalogAPIServer")
    public void setServiceCatalogAPIServer(ServiceCatalogAPIServer serviceCatalogAPIServer) {
        this.serviceCatalogAPIServer = serviceCatalogAPIServer;
    }

    /**
     * 
     * 
     * @return
     *     The serviceCatalogAPIServerList
     */
    @JsonProperty("ServiceCatalogAPIServerList")
    public ServiceCatalogAPIServerList getServiceCatalogAPIServerList() {
        return serviceCatalogAPIServerList;
    }

    /**
     * 
     * 
     * @param serviceCatalogAPIServerList
     *     The ServiceCatalogAPIServerList
     */
    @JsonProperty("ServiceCatalogAPIServerList")
    public void setServiceCatalogAPIServerList(ServiceCatalogAPIServerList serviceCatalogAPIServerList) {
        this.serviceCatalogAPIServerList = serviceCatalogAPIServerList;
    }

    /**
     * 
     * 
     * @return
     *     The serviceCatalogControllerManager
     */
    @JsonProperty("ServiceCatalogControllerManager")
    public ServiceCatalogControllerManager getServiceCatalogControllerManager() {
        return serviceCatalogControllerManager;
    }

    /**
     * 
     * 
     * @param serviceCatalogControllerManager
     *     The ServiceCatalogControllerManager
     */
    @JsonProperty("ServiceCatalogControllerManager")
    public void setServiceCatalogControllerManager(ServiceCatalogControllerManager serviceCatalogControllerManager) {
        this.serviceCatalogControllerManager = serviceCatalogControllerManager;
    }

    /**
     * 
     * 
     * @return
     *     The serviceCatalogControllerManagerList
     */
    @JsonProperty("ServiceCatalogControllerManagerList")
    public ServiceCatalogControllerManagerList getServiceCatalogControllerManagerList() {
        return serviceCatalogControllerManagerList;
    }

    /**
     * 
     * 
     * @param serviceCatalogControllerManagerList
     *     The ServiceCatalogControllerManagerList
     */
    @JsonProperty("ServiceCatalogControllerManagerList")
    public void setServiceCatalogControllerManagerList(ServiceCatalogControllerManagerList serviceCatalogControllerManagerList) {
        this.serviceCatalogControllerManagerList = serviceCatalogControllerManagerList;
    }

    /**
     * 
     * 
     * @return
     *     The status
     */
    @JsonProperty("Status")
    public Status getStatus() {
        return status;
    }

    /**
     * 
     * 
     * @param status
     *     The Status
     */
    @JsonProperty("Status")
    public void setStatus(Status status) {
        this.status = status;
    }

    /**
     * 
     * 
     * @return
     *     The time
     */
    @JsonProperty("Time")
    public String getTime() {
        return time;
    }

    /**
     * 
     * 
     * @param time
     *     The Time
     */
    @JsonProperty("Time")
    public void setTime(String time) {
        this.time = time;
    }

    /**
     * 
     * 
     * @return
     *     The typeMeta
     */
    @JsonProperty("TypeMeta")
    public TypeMeta getTypeMeta() {
        return typeMeta;
    }

    /**
     * 
     * 
     * @param typeMeta
     *     The TypeMeta
     */
    @JsonProperty("TypeMeta")
    public void setTypeMeta(TypeMeta typeMeta) {
        this.typeMeta = typeMeta;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
