package io.fabric8.openshift.api.model.operator.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface RepositoryDigestMirrorsFluent<A extends RepositoryDigestMirrorsFluent<A>> extends Fluent<A> {


    public A addToMirrors(int index,String item);
    public A setToMirrors(int index,String item);
    public A addToMirrors(String... items);
    public A addAllToMirrors(Collection<String> items);
    public A removeFromMirrors(String... items);
    public A removeAllFromMirrors(Collection<String> items);
    public List<String> getMirrors();
    public String getMirror(int index);
    public String getFirstMirror();
    public String getLastMirror();
    public String getMatchingMirror(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingMirror(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withMirrors(List<String> mirrors);
    public A withMirrors(String... mirrors);
    public Boolean hasMirrors();
    public A addNewMirror(String arg1);
    public A addNewMirror(StringBuilder arg1);
    public A addNewMirror(StringBuffer arg1);
    public String getSource();
    public A withSource(String source);
    public Boolean hasSource();
    public A withNewSource(String arg1);
    public A withNewSource(StringBuilder arg1);
    public A withNewSource(StringBuffer arg1);
}
