package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SyslogLoggingDestinationParametersBuilder extends SyslogLoggingDestinationParametersFluentImpl<SyslogLoggingDestinationParametersBuilder> implements VisitableBuilder<SyslogLoggingDestinationParameters,SyslogLoggingDestinationParametersBuilder> {

    SyslogLoggingDestinationParametersFluent<?> fluent;
    Boolean validationEnabled;

    public SyslogLoggingDestinationParametersBuilder() { 
        this(true);
    }


    public SyslogLoggingDestinationParametersBuilder(Boolean validationEnabled) { 
        this(new SyslogLoggingDestinationParameters(), validationEnabled);
    }


    public SyslogLoggingDestinationParametersBuilder(SyslogLoggingDestinationParametersFluent<?> fluent) { 
        this(fluent, true);
    }


    public SyslogLoggingDestinationParametersBuilder(SyslogLoggingDestinationParametersFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new SyslogLoggingDestinationParameters(), validationEnabled);
    }


    public SyslogLoggingDestinationParametersBuilder(SyslogLoggingDestinationParametersFluent<?> fluent,SyslogLoggingDestinationParameters instance) { 
        this(fluent, instance, true);
    }


    public SyslogLoggingDestinationParametersBuilder(SyslogLoggingDestinationParametersFluent<?> fluent,SyslogLoggingDestinationParameters instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAddress(instance.getAddress()); 
        fluent.withFacility(instance.getFacility()); 
        fluent.withPort(instance.getPort()); 
        this.validationEnabled = validationEnabled; 
    }


    public SyslogLoggingDestinationParametersBuilder(SyslogLoggingDestinationParameters instance) { 
        this(instance,true);
    }


    public SyslogLoggingDestinationParametersBuilder(SyslogLoggingDestinationParameters instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAddress(instance.getAddress()); 
        this.withFacility(instance.getFacility()); 
        this.withPort(instance.getPort()); 
        this.validationEnabled = validationEnabled; 
    }


    public SyslogLoggingDestinationParameters build() {
        SyslogLoggingDestinationParameters buildable = new SyslogLoggingDestinationParameters(fluent.getAddress(),fluent.getFacility(),fluent.getPort());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SyslogLoggingDestinationParametersBuilder that = (SyslogLoggingDestinationParametersBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
