package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceCatalogControllerManagerStatusBuilder extends ServiceCatalogControllerManagerStatusFluentImpl<ServiceCatalogControllerManagerStatusBuilder> implements VisitableBuilder<ServiceCatalogControllerManagerStatus,ServiceCatalogControllerManagerStatusBuilder> {

    ServiceCatalogControllerManagerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceCatalogControllerManagerStatusBuilder() { 
        this(true);
    }


    public ServiceCatalogControllerManagerStatusBuilder(Boolean validationEnabled) { 
        this(new ServiceCatalogControllerManagerStatus(), validationEnabled);
    }


    public ServiceCatalogControllerManagerStatusBuilder(ServiceCatalogControllerManagerStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public ServiceCatalogControllerManagerStatusBuilder(ServiceCatalogControllerManagerStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ServiceCatalogControllerManagerStatus(), validationEnabled);
    }


    public ServiceCatalogControllerManagerStatusBuilder(ServiceCatalogControllerManagerStatusFluent<?> fluent,ServiceCatalogControllerManagerStatus instance) { 
        this(fluent, instance, true);
    }


    public ServiceCatalogControllerManagerStatusBuilder(ServiceCatalogControllerManagerStatusFluent<?> fluent,ServiceCatalogControllerManagerStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withConditions(instance.getConditions()); 
        fluent.withGenerations(instance.getGenerations()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withReadyReplicas(instance.getReadyReplicas()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }


    public ServiceCatalogControllerManagerStatusBuilder(ServiceCatalogControllerManagerStatus instance) { 
        this(instance,true);
    }


    public ServiceCatalogControllerManagerStatusBuilder(ServiceCatalogControllerManagerStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withConditions(instance.getConditions()); 
        this.withGenerations(instance.getGenerations()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withReadyReplicas(instance.getReadyReplicas()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }


    public ServiceCatalogControllerManagerStatus build() {
        ServiceCatalogControllerManagerStatus buildable = new ServiceCatalogControllerManagerStatus(fluent.getConditions(),fluent.getGenerations(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceCatalogControllerManagerStatusBuilder that = (ServiceCatalogControllerManagerStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
