package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceCatalogControllerManagerSpecBuilder extends ServiceCatalogControllerManagerSpecFluentImpl<ServiceCatalogControllerManagerSpecBuilder> implements VisitableBuilder<ServiceCatalogControllerManagerSpec,ServiceCatalogControllerManagerSpecBuilder> {

    ServiceCatalogControllerManagerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceCatalogControllerManagerSpecBuilder() { 
        this(true);
    }


    public ServiceCatalogControllerManagerSpecBuilder(Boolean validationEnabled) { 
        this(new ServiceCatalogControllerManagerSpec(), validationEnabled);
    }


    public ServiceCatalogControllerManagerSpecBuilder(ServiceCatalogControllerManagerSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public ServiceCatalogControllerManagerSpecBuilder(ServiceCatalogControllerManagerSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ServiceCatalogControllerManagerSpec(), validationEnabled);
    }


    public ServiceCatalogControllerManagerSpecBuilder(ServiceCatalogControllerManagerSpecFluent<?> fluent,ServiceCatalogControllerManagerSpec instance) { 
        this(fluent, instance, true);
    }


    public ServiceCatalogControllerManagerSpecBuilder(ServiceCatalogControllerManagerSpecFluent<?> fluent,ServiceCatalogControllerManagerSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withLogLevel(instance.getLogLevel()); 
        fluent.withManagementState(instance.getManagementState()); 
        fluent.withObservedConfig(instance.getObservedConfig()); 
        fluent.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
        this.validationEnabled = validationEnabled; 
    }


    public ServiceCatalogControllerManagerSpecBuilder(ServiceCatalogControllerManagerSpec instance) { 
        this(instance,true);
    }


    public ServiceCatalogControllerManagerSpecBuilder(ServiceCatalogControllerManagerSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withLogLevel(instance.getLogLevel()); 
        this.withManagementState(instance.getManagementState()); 
        this.withObservedConfig(instance.getObservedConfig()); 
        this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
        this.validationEnabled = validationEnabled; 
    }


    public ServiceCatalogControllerManagerSpec build() {
        ServiceCatalogControllerManagerSpec buildable = new ServiceCatalogControllerManagerSpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getUnsupportedConfigOverrides());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceCatalogControllerManagerSpecBuilder that = (ServiceCatalogControllerManagerSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
