package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubeSchedulerListBuilder extends KubeSchedulerListFluentImpl<KubeSchedulerListBuilder> implements VisitableBuilder<KubeSchedulerList,KubeSchedulerListBuilder> {

    KubeSchedulerListFluent<?> fluent;
    Boolean validationEnabled;

    public KubeSchedulerListBuilder() { 
        this(true);
    }


    public KubeSchedulerListBuilder(Boolean validationEnabled) { 
        this(new KubeSchedulerList(), validationEnabled);
    }


    public KubeSchedulerListBuilder(KubeSchedulerListFluent<?> fluent) { 
        this(fluent, true);
    }


    public KubeSchedulerListBuilder(KubeSchedulerListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new KubeSchedulerList(), validationEnabled);
    }


    public KubeSchedulerListBuilder(KubeSchedulerListFluent<?> fluent,KubeSchedulerList instance) { 
        this(fluent, instance, true);
    }


    public KubeSchedulerListBuilder(KubeSchedulerListFluent<?> fluent,KubeSchedulerList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public KubeSchedulerListBuilder(KubeSchedulerList instance) { 
        this(instance,true);
    }


    public KubeSchedulerListBuilder(KubeSchedulerList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public KubeSchedulerList build() {
        KubeSchedulerList buildable = new KubeSchedulerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KubeSchedulerListBuilder that = (KubeSchedulerListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
