package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.openshift.api.model.TLSSecurityProfile;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.TLSSecurityProfileBuilder;
import io.fabric8.openshift.api.model.TLSSecurityProfileFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.Integer;
import java.lang.StringBuffer;

public class IngressControllerSpecFluentImpl<A extends IngressControllerSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IngressControllerSpecFluent<A> {

    private LocalObjectReferenceBuilder defaultCertificate;
    private String domain;
    private EndpointPublishingStrategyBuilder endpointPublishingStrategy;
    private IngressControllerHTTPHeadersBuilder httpHeaders;
    private IngressControllerLoggingBuilder logging;
    private LabelSelectorBuilder namespaceSelector;
    private NodePlacementBuilder nodePlacement;
    private Integer replicas;
    private RouteAdmissionPolicyBuilder routeAdmission;
    private LabelSelectorBuilder routeSelector;
    private TLSSecurityProfileBuilder tlsSecurityProfile;

    public IngressControllerSpecFluentImpl() { 
    }


    public IngressControllerSpecFluentImpl(IngressControllerSpec instance) { 
        this.withDefaultCertificate(instance.getDefaultCertificate()); 
        this.withDomain(instance.getDomain()); 
        this.withEndpointPublishingStrategy(instance.getEndpointPublishingStrategy()); 
        this.withHttpHeaders(instance.getHttpHeaders()); 
        this.withLogging(instance.getLogging()); 
        this.withNamespaceSelector(instance.getNamespaceSelector()); 
        this.withNodePlacement(instance.getNodePlacement()); 
        this.withReplicas(instance.getReplicas()); 
        this.withRouteAdmission(instance.getRouteAdmission()); 
        this.withRouteSelector(instance.getRouteSelector()); 
        this.withTlsSecurityProfile(instance.getTlsSecurityProfile()); 
    }


    
/**
 * This method has been deprecated, please use method buildDefaultCertificate instead.
 * @return The buildable object.
 */
@Deprecated public LocalObjectReference getDefaultCertificate() {
        return this.defaultCertificate!=null?this.defaultCertificate.build():null;
    }

    public LocalObjectReference buildDefaultCertificate() {
        return this.defaultCertificate!=null?this.defaultCertificate.build():null;
    }

    public A withDefaultCertificate(LocalObjectReference defaultCertificate) {
        _visitables.get("defaultCertificate").remove(this.defaultCertificate);
        if (defaultCertificate!=null){ this.defaultCertificate= new LocalObjectReferenceBuilder(defaultCertificate); _visitables.get("defaultCertificate").add(this.defaultCertificate);} return (A) this;
    }

    public Boolean hasDefaultCertificate() {
        return this.defaultCertificate != null;
    }

    public A withNewDefaultCertificate(String name) {
        return (A)withDefaultCertificate(new LocalObjectReference(name));
    }

    public IngressControllerSpecFluent.DefaultCertificateNested<A> withNewDefaultCertificate() {
        return new DefaultCertificateNestedImpl();
    }

    public IngressControllerSpecFluent.DefaultCertificateNested<A> withNewDefaultCertificateLike(LocalObjectReference item) {
        return new DefaultCertificateNestedImpl(item);
    }

    public IngressControllerSpecFluent.DefaultCertificateNested<A> editDefaultCertificate() {
        return withNewDefaultCertificateLike(getDefaultCertificate());
    }

    public IngressControllerSpecFluent.DefaultCertificateNested<A> editOrNewDefaultCertificate() {
        return withNewDefaultCertificateLike(getDefaultCertificate() != null ? getDefaultCertificate(): new LocalObjectReferenceBuilder().build());
    }

    public IngressControllerSpecFluent.DefaultCertificateNested<A> editOrNewDefaultCertificateLike(LocalObjectReference item) {
        return withNewDefaultCertificateLike(getDefaultCertificate() != null ? getDefaultCertificate(): item);
    }

    public String getDomain() {
        return this.domain;
    }

    public A withDomain(String domain) {
        this.domain=domain; return (A) this;
    }

    public Boolean hasDomain() {
        return this.domain != null;
    }

    public A withNewDomain(String arg1) {
        return (A)withDomain(new String(arg1));
    }

    public A withNewDomain(StringBuilder arg1) {
        return (A)withDomain(new String(arg1));
    }

    public A withNewDomain(StringBuffer arg1) {
        return (A)withDomain(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildEndpointPublishingStrategy instead.
 * @return The buildable object.
 */
@Deprecated public EndpointPublishingStrategy getEndpointPublishingStrategy() {
        return this.endpointPublishingStrategy!=null?this.endpointPublishingStrategy.build():null;
    }

    public EndpointPublishingStrategy buildEndpointPublishingStrategy() {
        return this.endpointPublishingStrategy!=null?this.endpointPublishingStrategy.build():null;
    }

    public A withEndpointPublishingStrategy(EndpointPublishingStrategy endpointPublishingStrategy) {
        _visitables.get("endpointPublishingStrategy").remove(this.endpointPublishingStrategy);
        if (endpointPublishingStrategy!=null){ this.endpointPublishingStrategy= new EndpointPublishingStrategyBuilder(endpointPublishingStrategy); _visitables.get("endpointPublishingStrategy").add(this.endpointPublishingStrategy);} return (A) this;
    }

    public Boolean hasEndpointPublishingStrategy() {
        return this.endpointPublishingStrategy != null;
    }

    public IngressControllerSpecFluent.EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategy() {
        return new EndpointPublishingStrategyNestedImpl();
    }

    public IngressControllerSpecFluent.EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item) {
        return new EndpointPublishingStrategyNestedImpl(item);
    }

    public IngressControllerSpecFluent.EndpointPublishingStrategyNested<A> editEndpointPublishingStrategy() {
        return withNewEndpointPublishingStrategyLike(getEndpointPublishingStrategy());
    }

    public IngressControllerSpecFluent.EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategy() {
        return withNewEndpointPublishingStrategyLike(getEndpointPublishingStrategy() != null ? getEndpointPublishingStrategy(): new EndpointPublishingStrategyBuilder().build());
    }

    public IngressControllerSpecFluent.EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item) {
        return withNewEndpointPublishingStrategyLike(getEndpointPublishingStrategy() != null ? getEndpointPublishingStrategy(): item);
    }

    
/**
 * This method has been deprecated, please use method buildHttpHeaders instead.
 * @return The buildable object.
 */
@Deprecated public IngressControllerHTTPHeaders getHttpHeaders() {
        return this.httpHeaders!=null?this.httpHeaders.build():null;
    }

    public IngressControllerHTTPHeaders buildHttpHeaders() {
        return this.httpHeaders!=null?this.httpHeaders.build():null;
    }

    public A withHttpHeaders(IngressControllerHTTPHeaders httpHeaders) {
        _visitables.get("httpHeaders").remove(this.httpHeaders);
        if (httpHeaders!=null){ this.httpHeaders= new IngressControllerHTTPHeadersBuilder(httpHeaders); _visitables.get("httpHeaders").add(this.httpHeaders);} return (A) this;
    }

    public Boolean hasHttpHeaders() {
        return this.httpHeaders != null;
    }

    public IngressControllerSpecFluent.HttpHeadersNested<A> withNewHttpHeaders() {
        return new HttpHeadersNestedImpl();
    }

    public IngressControllerSpecFluent.HttpHeadersNested<A> withNewHttpHeadersLike(IngressControllerHTTPHeaders item) {
        return new HttpHeadersNestedImpl(item);
    }

    public IngressControllerSpecFluent.HttpHeadersNested<A> editHttpHeaders() {
        return withNewHttpHeadersLike(getHttpHeaders());
    }

    public IngressControllerSpecFluent.HttpHeadersNested<A> editOrNewHttpHeaders() {
        return withNewHttpHeadersLike(getHttpHeaders() != null ? getHttpHeaders(): new IngressControllerHTTPHeadersBuilder().build());
    }

    public IngressControllerSpecFluent.HttpHeadersNested<A> editOrNewHttpHeadersLike(IngressControllerHTTPHeaders item) {
        return withNewHttpHeadersLike(getHttpHeaders() != null ? getHttpHeaders(): item);
    }

    
/**
 * This method has been deprecated, please use method buildLogging instead.
 * @return The buildable object.
 */
@Deprecated public IngressControllerLogging getLogging() {
        return this.logging!=null?this.logging.build():null;
    }

    public IngressControllerLogging buildLogging() {
        return this.logging!=null?this.logging.build():null;
    }

    public A withLogging(IngressControllerLogging logging) {
        _visitables.get("logging").remove(this.logging);
        if (logging!=null){ this.logging= new IngressControllerLoggingBuilder(logging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public Boolean hasLogging() {
        return this.logging != null;
    }

    public IngressControllerSpecFluent.LoggingNested<A> withNewLogging() {
        return new LoggingNestedImpl();
    }

    public IngressControllerSpecFluent.LoggingNested<A> withNewLoggingLike(IngressControllerLogging item) {
        return new LoggingNestedImpl(item);
    }

    public IngressControllerSpecFluent.LoggingNested<A> editLogging() {
        return withNewLoggingLike(getLogging());
    }

    public IngressControllerSpecFluent.LoggingNested<A> editOrNewLogging() {
        return withNewLoggingLike(getLogging() != null ? getLogging(): new IngressControllerLoggingBuilder().build());
    }

    public IngressControllerSpecFluent.LoggingNested<A> editOrNewLoggingLike(IngressControllerLogging item) {
        return withNewLoggingLike(getLogging() != null ? getLogging(): item);
    }

    
/**
 * This method has been deprecated, please use method buildNamespaceSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getNamespaceSelector() {
        return this.namespaceSelector!=null?this.namespaceSelector.build():null;
    }

    public LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector!=null?this.namespaceSelector.build():null;
    }

    public A withNamespaceSelector(LabelSelector namespaceSelector) {
        _visitables.get("namespaceSelector").remove(this.namespaceSelector);
        if (namespaceSelector!=null){ this.namespaceSelector= new LabelSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} return (A) this;
    }

    public Boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public IngressControllerSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNestedImpl();
    }

    public IngressControllerSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
        return new NamespaceSelectorNestedImpl(item);
    }

    public IngressControllerSpecFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
        return withNewNamespaceSelectorLike(getNamespaceSelector());
    }

    public IngressControllerSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new LabelSelectorBuilder().build());
    }

    public IngressControllerSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
        return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildNodePlacement instead.
 * @return The buildable object.
 */
@Deprecated public NodePlacement getNodePlacement() {
        return this.nodePlacement!=null?this.nodePlacement.build():null;
    }

    public NodePlacement buildNodePlacement() {
        return this.nodePlacement!=null?this.nodePlacement.build():null;
    }

    public A withNodePlacement(NodePlacement nodePlacement) {
        _visitables.get("nodePlacement").remove(this.nodePlacement);
        if (nodePlacement!=null){ this.nodePlacement= new NodePlacementBuilder(nodePlacement); _visitables.get("nodePlacement").add(this.nodePlacement);} return (A) this;
    }

    public Boolean hasNodePlacement() {
        return this.nodePlacement != null;
    }

    public IngressControllerSpecFluent.NodePlacementNested<A> withNewNodePlacement() {
        return new NodePlacementNestedImpl();
    }

    public IngressControllerSpecFluent.NodePlacementNested<A> withNewNodePlacementLike(NodePlacement item) {
        return new NodePlacementNestedImpl(item);
    }

    public IngressControllerSpecFluent.NodePlacementNested<A> editNodePlacement() {
        return withNewNodePlacementLike(getNodePlacement());
    }

    public IngressControllerSpecFluent.NodePlacementNested<A> editOrNewNodePlacement() {
        return withNewNodePlacementLike(getNodePlacement() != null ? getNodePlacement(): new NodePlacementBuilder().build());
    }

    public IngressControllerSpecFluent.NodePlacementNested<A> editOrNewNodePlacementLike(NodePlacement item) {
        return withNewNodePlacementLike(getNodePlacement() != null ? getNodePlacement(): item);
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    
/**
 * This method has been deprecated, please use method buildRouteAdmission instead.
 * @return The buildable object.
 */
@Deprecated public RouteAdmissionPolicy getRouteAdmission() {
        return this.routeAdmission!=null?this.routeAdmission.build():null;
    }

    public RouteAdmissionPolicy buildRouteAdmission() {
        return this.routeAdmission!=null?this.routeAdmission.build():null;
    }

    public A withRouteAdmission(RouteAdmissionPolicy routeAdmission) {
        _visitables.get("routeAdmission").remove(this.routeAdmission);
        if (routeAdmission!=null){ this.routeAdmission= new RouteAdmissionPolicyBuilder(routeAdmission); _visitables.get("routeAdmission").add(this.routeAdmission);} return (A) this;
    }

    public Boolean hasRouteAdmission() {
        return this.routeAdmission != null;
    }

    public A withNewRouteAdmission(String namespaceOwnership,String wildcardPolicy) {
        return (A)withRouteAdmission(new RouteAdmissionPolicy(namespaceOwnership, wildcardPolicy));
    }

    public IngressControllerSpecFluent.RouteAdmissionNested<A> withNewRouteAdmission() {
        return new RouteAdmissionNestedImpl();
    }

    public IngressControllerSpecFluent.RouteAdmissionNested<A> withNewRouteAdmissionLike(RouteAdmissionPolicy item) {
        return new RouteAdmissionNestedImpl(item);
    }

    public IngressControllerSpecFluent.RouteAdmissionNested<A> editRouteAdmission() {
        return withNewRouteAdmissionLike(getRouteAdmission());
    }

    public IngressControllerSpecFluent.RouteAdmissionNested<A> editOrNewRouteAdmission() {
        return withNewRouteAdmissionLike(getRouteAdmission() != null ? getRouteAdmission(): new RouteAdmissionPolicyBuilder().build());
    }

    public IngressControllerSpecFluent.RouteAdmissionNested<A> editOrNewRouteAdmissionLike(RouteAdmissionPolicy item) {
        return withNewRouteAdmissionLike(getRouteAdmission() != null ? getRouteAdmission(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRouteSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getRouteSelector() {
        return this.routeSelector!=null?this.routeSelector.build():null;
    }

    public LabelSelector buildRouteSelector() {
        return this.routeSelector!=null?this.routeSelector.build():null;
    }

    public A withRouteSelector(LabelSelector routeSelector) {
        _visitables.get("routeSelector").remove(this.routeSelector);
        if (routeSelector!=null){ this.routeSelector= new LabelSelectorBuilder(routeSelector); _visitables.get("routeSelector").add(this.routeSelector);} return (A) this;
    }

    public Boolean hasRouteSelector() {
        return this.routeSelector != null;
    }

    public IngressControllerSpecFluent.RouteSelectorNested<A> withNewRouteSelector() {
        return new RouteSelectorNestedImpl();
    }

    public IngressControllerSpecFluent.RouteSelectorNested<A> withNewRouteSelectorLike(LabelSelector item) {
        return new RouteSelectorNestedImpl(item);
    }

    public IngressControllerSpecFluent.RouteSelectorNested<A> editRouteSelector() {
        return withNewRouteSelectorLike(getRouteSelector());
    }

    public IngressControllerSpecFluent.RouteSelectorNested<A> editOrNewRouteSelector() {
        return withNewRouteSelectorLike(getRouteSelector() != null ? getRouteSelector(): new LabelSelectorBuilder().build());
    }

    public IngressControllerSpecFluent.RouteSelectorNested<A> editOrNewRouteSelectorLike(LabelSelector item) {
        return withNewRouteSelectorLike(getRouteSelector() != null ? getRouteSelector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTlsSecurityProfile instead.
 * @return The buildable object.
 */
@Deprecated public TLSSecurityProfile getTlsSecurityProfile() {
        return this.tlsSecurityProfile!=null?this.tlsSecurityProfile.build():null;
    }

    public TLSSecurityProfile buildTlsSecurityProfile() {
        return this.tlsSecurityProfile!=null?this.tlsSecurityProfile.build():null;
    }

    public A withTlsSecurityProfile(TLSSecurityProfile tlsSecurityProfile) {
        _visitables.get("tlsSecurityProfile").remove(this.tlsSecurityProfile);
        if (tlsSecurityProfile!=null){ this.tlsSecurityProfile= new TLSSecurityProfileBuilder(tlsSecurityProfile); _visitables.get("tlsSecurityProfile").add(this.tlsSecurityProfile);} return (A) this;
    }

    public Boolean hasTlsSecurityProfile() {
        return this.tlsSecurityProfile != null;
    }

    public IngressControllerSpecFluent.TlsSecurityProfileNested<A> withNewTlsSecurityProfile() {
        return new TlsSecurityProfileNestedImpl();
    }

    public IngressControllerSpecFluent.TlsSecurityProfileNested<A> withNewTlsSecurityProfileLike(TLSSecurityProfile item) {
        return new TlsSecurityProfileNestedImpl(item);
    }

    public IngressControllerSpecFluent.TlsSecurityProfileNested<A> editTlsSecurityProfile() {
        return withNewTlsSecurityProfileLike(getTlsSecurityProfile());
    }

    public IngressControllerSpecFluent.TlsSecurityProfileNested<A> editOrNewTlsSecurityProfile() {
        return withNewTlsSecurityProfileLike(getTlsSecurityProfile() != null ? getTlsSecurityProfile(): new TLSSecurityProfileBuilder().build());
    }

    public IngressControllerSpecFluent.TlsSecurityProfileNested<A> editOrNewTlsSecurityProfileLike(TLSSecurityProfile item) {
        return withNewTlsSecurityProfileLike(getTlsSecurityProfile() != null ? getTlsSecurityProfile(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IngressControllerSpecFluentImpl that = (IngressControllerSpecFluentImpl) o;
        if (defaultCertificate != null ? !defaultCertificate.equals(that.defaultCertificate) :that.defaultCertificate != null) return false;
        if (domain != null ? !domain.equals(that.domain) :that.domain != null) return false;
        if (endpointPublishingStrategy != null ? !endpointPublishingStrategy.equals(that.endpointPublishingStrategy) :that.endpointPublishingStrategy != null) return false;
        if (httpHeaders != null ? !httpHeaders.equals(that.httpHeaders) :that.httpHeaders != null) return false;
        if (logging != null ? !logging.equals(that.logging) :that.logging != null) return false;
        if (namespaceSelector != null ? !namespaceSelector.equals(that.namespaceSelector) :that.namespaceSelector != null) return false;
        if (nodePlacement != null ? !nodePlacement.equals(that.nodePlacement) :that.nodePlacement != null) return false;
        if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
        if (routeAdmission != null ? !routeAdmission.equals(that.routeAdmission) :that.routeAdmission != null) return false;
        if (routeSelector != null ? !routeSelector.equals(that.routeSelector) :that.routeSelector != null) return false;
        if (tlsSecurityProfile != null ? !tlsSecurityProfile.equals(that.tlsSecurityProfile) :that.tlsSecurityProfile != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(defaultCertificate,  domain,  endpointPublishingStrategy,  httpHeaders,  logging,  namespaceSelector,  nodePlacement,  replicas,  routeAdmission,  routeSelector,  tlsSecurityProfile,  super.hashCode());
    }

    public class DefaultCertificateNestedImpl<N> extends LocalObjectReferenceFluentImpl<IngressControllerSpecFluent.DefaultCertificateNested<N>> implements IngressControllerSpecFluent.DefaultCertificateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        DefaultCertificateNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        DefaultCertificateNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        public N and() {
             return (N) IngressControllerSpecFluentImpl.this.withDefaultCertificate(builder.build());
        }

        public N endDefaultCertificate() {
             return and();
        }
    }


    public class EndpointPublishingStrategyNestedImpl<N> extends EndpointPublishingStrategyFluentImpl<IngressControllerSpecFluent.EndpointPublishingStrategyNested<N>> implements IngressControllerSpecFluent.EndpointPublishingStrategyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EndpointPublishingStrategyBuilder builder;

        EndpointPublishingStrategyNestedImpl(EndpointPublishingStrategy item) {
            this.builder = new EndpointPublishingStrategyBuilder(this, item);
        }

        EndpointPublishingStrategyNestedImpl() {
            this.builder = new EndpointPublishingStrategyBuilder(this);
        }

        public N and() {
             return (N) IngressControllerSpecFluentImpl.this.withEndpointPublishingStrategy(builder.build());
        }

        public N endEndpointPublishingStrategy() {
             return and();
        }
    }


    public class HttpHeadersNestedImpl<N> extends IngressControllerHTTPHeadersFluentImpl<IngressControllerSpecFluent.HttpHeadersNested<N>> implements IngressControllerSpecFluent.HttpHeadersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IngressControllerHTTPHeadersBuilder builder;

        HttpHeadersNestedImpl(IngressControllerHTTPHeaders item) {
            this.builder = new IngressControllerHTTPHeadersBuilder(this, item);
        }

        HttpHeadersNestedImpl() {
            this.builder = new IngressControllerHTTPHeadersBuilder(this);
        }

        public N and() {
             return (N) IngressControllerSpecFluentImpl.this.withHttpHeaders(builder.build());
        }

        public N endHttpHeaders() {
             return and();
        }
    }


    public class LoggingNestedImpl<N> extends IngressControllerLoggingFluentImpl<IngressControllerSpecFluent.LoggingNested<N>> implements IngressControllerSpecFluent.LoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IngressControllerLoggingBuilder builder;

        LoggingNestedImpl(IngressControllerLogging item) {
            this.builder = new IngressControllerLoggingBuilder(this, item);
        }

        LoggingNestedImpl() {
            this.builder = new IngressControllerLoggingBuilder(this);
        }

        public N and() {
             return (N) IngressControllerSpecFluentImpl.this.withLogging(builder.build());
        }

        public N endLogging() {
             return and();
        }
    }


    public class NamespaceSelectorNestedImpl<N> extends LabelSelectorFluentImpl<IngressControllerSpecFluent.NamespaceSelectorNested<N>> implements IngressControllerSpecFluent.NamespaceSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

        NamespaceSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        NamespaceSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        public N and() {
             return (N) IngressControllerSpecFluentImpl.this.withNamespaceSelector(builder.build());
        }

        public N endNamespaceSelector() {
             return and();
        }
    }


    public class NodePlacementNestedImpl<N> extends NodePlacementFluentImpl<IngressControllerSpecFluent.NodePlacementNested<N>> implements IngressControllerSpecFluent.NodePlacementNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NodePlacementBuilder builder;

        NodePlacementNestedImpl(NodePlacement item) {
            this.builder = new NodePlacementBuilder(this, item);
        }

        NodePlacementNestedImpl() {
            this.builder = new NodePlacementBuilder(this);
        }

        public N and() {
             return (N) IngressControllerSpecFluentImpl.this.withNodePlacement(builder.build());
        }

        public N endNodePlacement() {
             return and();
        }
    }


    public class RouteAdmissionNestedImpl<N> extends RouteAdmissionPolicyFluentImpl<IngressControllerSpecFluent.RouteAdmissionNested<N>> implements IngressControllerSpecFluent.RouteAdmissionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RouteAdmissionPolicyBuilder builder;

        RouteAdmissionNestedImpl(RouteAdmissionPolicy item) {
            this.builder = new RouteAdmissionPolicyBuilder(this, item);
        }

        RouteAdmissionNestedImpl() {
            this.builder = new RouteAdmissionPolicyBuilder(this);
        }

        public N and() {
             return (N) IngressControllerSpecFluentImpl.this.withRouteAdmission(builder.build());
        }

        public N endRouteAdmission() {
             return and();
        }
    }


    public class RouteSelectorNestedImpl<N> extends LabelSelectorFluentImpl<IngressControllerSpecFluent.RouteSelectorNested<N>> implements IngressControllerSpecFluent.RouteSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

        RouteSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        RouteSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        public N and() {
             return (N) IngressControllerSpecFluentImpl.this.withRouteSelector(builder.build());
        }

        public N endRouteSelector() {
             return and();
        }
    }


    public class TlsSecurityProfileNestedImpl<N> extends TLSSecurityProfileFluentImpl<IngressControllerSpecFluent.TlsSecurityProfileNested<N>> implements IngressControllerSpecFluent.TlsSecurityProfileNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TLSSecurityProfileBuilder builder;

        TlsSecurityProfileNestedImpl(TLSSecurityProfile item) {
            this.builder = new TLSSecurityProfileBuilder(this, item);
        }

        TlsSecurityProfileNestedImpl() {
            this.builder = new TLSSecurityProfileBuilder(this);
        }

        public N and() {
             return (N) IngressControllerSpecFluentImpl.this.withTlsSecurityProfile(builder.build());
        }

        public N endTlsSecurityProfile() {
             return and();
        }
    }


}
