package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class ImagePrunerSpecFluentImpl<A extends ImagePrunerSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ImagePrunerSpecFluent<A> {

    private Affinity affinity;
    private Integer failedJobsHistoryLimit;
    private Boolean ignoreInvalidImageReferences;
    private Integer keepTagRevisions;
    private Long keepYoungerThan;
    private Duration keepYoungerThanDuration;
    private Map<String,String> nodeSelector;
    private ResourceRequirementsBuilder resources;
    private String schedule;
    private Integer successfulJobsHistoryLimit;
    private Boolean suspend;
    private List<Toleration> tolerations = new ArrayList<Toleration>();

    public ImagePrunerSpecFluentImpl() { 
    }


    public ImagePrunerSpecFluentImpl(ImagePrunerSpec instance) { 
        this.withAffinity(instance.getAffinity()); 
        this.withFailedJobsHistoryLimit(instance.getFailedJobsHistoryLimit()); 
        this.withIgnoreInvalidImageReferences(instance.getIgnoreInvalidImageReferences()); 
        this.withKeepTagRevisions(instance.getKeepTagRevisions()); 
        this.withKeepYoungerThan(instance.getKeepYoungerThan()); 
        this.withKeepYoungerThanDuration(instance.getKeepYoungerThanDuration()); 
        this.withNodeSelector(instance.getNodeSelector()); 
        this.withResources(instance.getResources()); 
        this.withSchedule(instance.getSchedule()); 
        this.withSuccessfulJobsHistoryLimit(instance.getSuccessfulJobsHistoryLimit()); 
        this.withSuspend(instance.getSuspend()); 
        this.withTolerations(instance.getTolerations()); 
    }


    public Affinity getAffinity() {
        return this.affinity;
    }

    public A withAffinity(Affinity affinity) {
        this.affinity=affinity; return (A) this;
    }

    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    public Integer getFailedJobsHistoryLimit() {
        return this.failedJobsHistoryLimit;
    }

    public A withFailedJobsHistoryLimit(Integer failedJobsHistoryLimit) {
        this.failedJobsHistoryLimit=failedJobsHistoryLimit; return (A) this;
    }

    public Boolean hasFailedJobsHistoryLimit() {
        return this.failedJobsHistoryLimit != null;
    }

    public Boolean isIgnoreInvalidImageReferences() {
        return this.ignoreInvalidImageReferences;
    }

    public A withIgnoreInvalidImageReferences(Boolean ignoreInvalidImageReferences) {
        this.ignoreInvalidImageReferences=ignoreInvalidImageReferences; return (A) this;
    }

    public Boolean hasIgnoreInvalidImageReferences() {
        return this.ignoreInvalidImageReferences != null;
    }

    public A withNewIgnoreInvalidImageReferences(String arg1) {
        return (A)withIgnoreInvalidImageReferences(new Boolean(arg1));
    }

    public A withNewIgnoreInvalidImageReferences(boolean arg1) {
        return (A)withIgnoreInvalidImageReferences(new Boolean(arg1));
    }

    public Integer getKeepTagRevisions() {
        return this.keepTagRevisions;
    }

    public A withKeepTagRevisions(Integer keepTagRevisions) {
        this.keepTagRevisions=keepTagRevisions; return (A) this;
    }

    public Boolean hasKeepTagRevisions() {
        return this.keepTagRevisions != null;
    }

    public Long getKeepYoungerThan() {
        return this.keepYoungerThan;
    }

    public A withKeepYoungerThan(Long keepYoungerThan) {
        this.keepYoungerThan=keepYoungerThan; return (A) this;
    }

    public Boolean hasKeepYoungerThan() {
        return this.keepYoungerThan != null;
    }

    public Duration getKeepYoungerThanDuration() {
        return this.keepYoungerThanDuration;
    }

    public A withKeepYoungerThanDuration(Duration keepYoungerThanDuration) {
        this.keepYoungerThanDuration=keepYoungerThanDuration; return (A) this;
    }

    public Boolean hasKeepYoungerThanDuration() {
        return this.keepYoungerThanDuration != null;
    }

    public A addToNodeSelector(String key,String value) {
        if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
    }

    public A addToNodeSelector(Map<String,String> map) {
        if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap<String,String>(); }
        if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
    }

    public A removeFromNodeSelector(String key) {
        if(this.nodeSelector == null) { return (A) this; }
        if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
    }

    public A removeFromNodeSelector(Map<String,String> map) {
        if(this.nodeSelector == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
    }

    public Map<String,String> getNodeSelector() {
        return this.nodeSelector;
    }

    public A withNodeSelector(Map<String,String> nodeSelector) {
        if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new LinkedHashMap<String,String>(nodeSelector);} return (A) this;
    }

    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public ResourceRequirements getResources() {
        return this.resources!=null?this.resources.build():null;
    }

    public ResourceRequirements buildResources() {
        return this.resources!=null?this.resources.build():null;
    }

    public A withResources(ResourceRequirements resources) {
        _visitables.get("resources").remove(this.resources);
        if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} return (A) this;
    }

    public Boolean hasResources() {
        return this.resources != null;
    }

    public ImagePrunerSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    public ImagePrunerSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    public ImagePrunerSpecFluent.ResourcesNested<A> editResources() {
        return withNewResourcesLike(getResources());
    }

    public ImagePrunerSpecFluent.ResourcesNested<A> editOrNewResources() {
        return withNewResourcesLike(getResources() != null ? getResources(): new ResourceRequirementsBuilder().build());
    }

    public ImagePrunerSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return withNewResourcesLike(getResources() != null ? getResources(): item);
    }

    public String getSchedule() {
        return this.schedule;
    }

    public A withSchedule(String schedule) {
        this.schedule=schedule; return (A) this;
    }

    public Boolean hasSchedule() {
        return this.schedule != null;
    }

    public A withNewSchedule(String arg1) {
        return (A)withSchedule(new String(arg1));
    }

    public A withNewSchedule(StringBuilder arg1) {
        return (A)withSchedule(new String(arg1));
    }

    public A withNewSchedule(StringBuffer arg1) {
        return (A)withSchedule(new String(arg1));
    }

    public Integer getSuccessfulJobsHistoryLimit() {
        return this.successfulJobsHistoryLimit;
    }

    public A withSuccessfulJobsHistoryLimit(Integer successfulJobsHistoryLimit) {
        this.successfulJobsHistoryLimit=successfulJobsHistoryLimit; return (A) this;
    }

    public Boolean hasSuccessfulJobsHistoryLimit() {
        return this.successfulJobsHistoryLimit != null;
    }

    public Boolean isSuspend() {
        return this.suspend;
    }

    public A withSuspend(Boolean suspend) {
        this.suspend=suspend; return (A) this;
    }

    public Boolean hasSuspend() {
        return this.suspend != null;
    }

    public A withNewSuspend(String arg1) {
        return (A)withSuspend(new Boolean(arg1));
    }

    public A withNewSuspend(boolean arg1) {
        return (A)withSuspend(new Boolean(arg1));
    }

    public A addToTolerations(int index,Toleration item) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        this.tolerations.add(index, item);
        return (A)this;
    }

    public A setToTolerations(int index,Toleration item) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        this.tolerations.set(index, item); return (A)this;
    }

    public A addToTolerations(Toleration... items) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A removeFromTolerations(Toleration... items) {
        for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    public Toleration getLastToleration() {
        return this.tolerations.get(tolerations.size() - 1);
    }

    public Toleration getMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate) {
        for (Toleration item: tolerations) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate) {
        for (Toleration item: tolerations) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTolerations(List<Toleration> tolerations) {
        if (this.tolerations != null) { _visitables.get("tolerations").removeAll(this.tolerations);}
        if (tolerations != null) {this.tolerations = new ArrayList<Toleration>(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
    }

    public A withTolerations(Toleration... tolerations) {
        if (this.tolerations != null) {this.tolerations.clear();}
        if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
    }

    public Boolean hasTolerations() {
        return tolerations != null && !tolerations.isEmpty();
    }

    public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
        return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ImagePrunerSpecFluentImpl that = (ImagePrunerSpecFluentImpl) o;
        if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
        if (failedJobsHistoryLimit != null ? !failedJobsHistoryLimit.equals(that.failedJobsHistoryLimit) :that.failedJobsHistoryLimit != null) return false;
        if (ignoreInvalidImageReferences != null ? !ignoreInvalidImageReferences.equals(that.ignoreInvalidImageReferences) :that.ignoreInvalidImageReferences != null) return false;
        if (keepTagRevisions != null ? !keepTagRevisions.equals(that.keepTagRevisions) :that.keepTagRevisions != null) return false;
        if (keepYoungerThan != null ? !keepYoungerThan.equals(that.keepYoungerThan) :that.keepYoungerThan != null) return false;
        if (keepYoungerThanDuration != null ? !keepYoungerThanDuration.equals(that.keepYoungerThanDuration) :that.keepYoungerThanDuration != null) return false;
        if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (schedule != null ? !schedule.equals(that.schedule) :that.schedule != null) return false;
        if (successfulJobsHistoryLimit != null ? !successfulJobsHistoryLimit.equals(that.successfulJobsHistoryLimit) :that.successfulJobsHistoryLimit != null) return false;
        if (suspend != null ? !suspend.equals(that.suspend) :that.suspend != null) return false;
        if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(affinity,  failedJobsHistoryLimit,  ignoreInvalidImageReferences,  keepTagRevisions,  keepYoungerThan,  keepYoungerThanDuration,  nodeSelector,  resources,  schedule,  successfulJobsHistoryLimit,  suspend,  tolerations,  super.hashCode());
    }

    public class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<ImagePrunerSpecFluent.ResourcesNested<N>> implements ImagePrunerSpecFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceRequirementsBuilder builder;

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        public N and() {
             return (N) ImagePrunerSpecFluentImpl.this.withResources(builder.build());
        }

        public N endResources() {
             return and();
        }
    }


}
