package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface DNSStatusFluent<A extends DNSStatusFluent<A>> extends Fluent<A> {


    public String getClusterDomain();
    public A withClusterDomain(String clusterDomain);
    public Boolean hasClusterDomain();
    public A withNewClusterDomain(String arg1);
    public A withNewClusterDomain(StringBuilder arg1);
    public A withNewClusterDomain(StringBuffer arg1);
    public String getClusterIP();
    public A withClusterIP(String clusterIP);
    public Boolean hasClusterIP();
    public A withNewClusterIP(String arg1);
    public A withNewClusterIP(StringBuilder arg1);
    public A withNewClusterIP(StringBuffer arg1);
    public A addToConditions(int index,OperatorCondition item);
    public A setToConditions(int index,OperatorCondition item);
    public A addToConditions(OperatorCondition... items);
    public A addAllToConditions(Collection<OperatorCondition> items);
    public A removeFromConditions(OperatorCondition... items);
    public A removeAllFromConditions(Collection<OperatorCondition> items);
    public A removeMatchingFromConditions(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<OperatorCondition> getConditions();
    public List<OperatorCondition> buildConditions();
    public OperatorCondition buildCondition(int index);
    public OperatorCondition buildFirstCondition();
    public OperatorCondition buildLastCondition();
    public OperatorCondition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate);
    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate);
    public A withConditions(List<OperatorCondition> conditions);
    public A withConditions(OperatorCondition... conditions);
    public Boolean hasConditions();
    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
    public DNSStatusFluent.ConditionsNested<A> addNewCondition();
    public DNSStatusFluent.ConditionsNested<A> addNewConditionLike(OperatorCondition item);
    public DNSStatusFluent.ConditionsNested<A> setNewConditionLike(int index,OperatorCondition item);
    public DNSStatusFluent.ConditionsNested<A> editCondition(int index);
    public DNSStatusFluent.ConditionsNested<A> editFirstCondition();
    public DNSStatusFluent.ConditionsNested<A> editLastCondition();
    public DNSStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OperatorConditionFluent<DNSStatusFluent.ConditionsNested<N>> {

        public N and();
        public N endCondition();    }


}
