package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DNSListBuilder extends DNSListFluentImpl<DNSListBuilder> implements VisitableBuilder<DNSList,DNSListBuilder> {

    DNSListFluent<?> fluent;
    Boolean validationEnabled;

    public DNSListBuilder() { 
        this(true);
    }


    public DNSListBuilder(Boolean validationEnabled) { 
        this(new DNSList(), validationEnabled);
    }


    public DNSListBuilder(DNSListFluent<?> fluent) { 
        this(fluent, true);
    }


    public DNSListBuilder(DNSListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new DNSList(), validationEnabled);
    }


    public DNSListBuilder(DNSListFluent<?> fluent,DNSList instance) { 
        this(fluent, instance, true);
    }


    public DNSListBuilder(DNSListFluent<?> fluent,DNSList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public DNSListBuilder(DNSList instance) { 
        this(instance,true);
    }


    public DNSListBuilder(DNSList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public DNSList build() {
        DNSList buildable = new DNSList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DNSListBuilder that = (DNSListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
