package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface IngressControllerHTTPHeadersFluent<A extends IngressControllerHTTPHeadersFluent<A>> extends Fluent<A> {


    public String getForwardedHeaderPolicy();
    public A withForwardedHeaderPolicy(String forwardedHeaderPolicy);
    public Boolean hasForwardedHeaderPolicy();
    public A withNewForwardedHeaderPolicy(String arg1);
    public A withNewForwardedHeaderPolicy(StringBuilder arg1);
    public A withNewForwardedHeaderPolicy(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildUniqueId instead.
 * @return The buildable object.
 */
@Deprecated public IngressControllerHTTPUniqueIdHeaderPolicy getUniqueId();
    public IngressControllerHTTPUniqueIdHeaderPolicy buildUniqueId();
    public A withUniqueId(IngressControllerHTTPUniqueIdHeaderPolicy uniqueId);
    public Boolean hasUniqueId();
    public A withNewUniqueId(String format,String name);
    public IngressControllerHTTPHeadersFluent.UniqueIdNested<A> withNewUniqueId();
    public IngressControllerHTTPHeadersFluent.UniqueIdNested<A> withNewUniqueIdLike(IngressControllerHTTPUniqueIdHeaderPolicy item);
    public IngressControllerHTTPHeadersFluent.UniqueIdNested<A> editUniqueId();
    public IngressControllerHTTPHeadersFluent.UniqueIdNested<A> editOrNewUniqueId();
    public IngressControllerHTTPHeadersFluent.UniqueIdNested<A> editOrNewUniqueIdLike(IngressControllerHTTPUniqueIdHeaderPolicy item);
    public interface UniqueIdNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressControllerHTTPUniqueIdHeaderPolicyFluent<IngressControllerHTTPHeadersFluent.UniqueIdNested<N>> {

        public N and();
        public N endUniqueId();    }


}
