package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface DNSSpecFluent<A extends DNSSpecFluent<A>> extends Fluent<A> {


    public A addToServers(int index,Server item);
    public A setToServers(int index,Server item);
    public A addToServers(Server... items);
    public A addAllToServers(Collection<Server> items);
    public A removeFromServers(Server... items);
    public A removeAllFromServers(Collection<Server> items);
    public A removeMatchingFromServers(io.fabric8.kubernetes.api.builder.Predicate<ServerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildServers instead.
 * @return The buildable object.
 */
@Deprecated public List<Server> getServers();
    public List<Server> buildServers();
    public Server buildServer(int index);
    public Server buildFirstServer();
    public Server buildLastServer();
    public Server buildMatchingServer(io.fabric8.kubernetes.api.builder.Predicate<ServerBuilder> predicate);
    public Boolean hasMatchingServer(io.fabric8.kubernetes.api.builder.Predicate<ServerBuilder> predicate);
    public A withServers(List<Server> servers);
    public A withServers(Server... servers);
    public Boolean hasServers();
    public DNSSpecFluent.ServersNested<A> addNewServer();
    public DNSSpecFluent.ServersNested<A> addNewServerLike(Server item);
    public DNSSpecFluent.ServersNested<A> setNewServerLike(int index,Server item);
    public DNSSpecFluent.ServersNested<A> editServer(int index);
    public DNSSpecFluent.ServersNested<A> editFirstServer();
    public DNSSpecFluent.ServersNested<A> editLastServer();
    public DNSSpecFluent.ServersNested<A> editMatchingServer(io.fabric8.kubernetes.api.builder.Predicate<ServerBuilder> predicate);
    public interface ServersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServerFluent<DNSSpecFluent.ServersNested<N>> {

        public N and();
        public N endServer();    }


}
