package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class AuthenticationStatusFluentImpl<A extends AuthenticationStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AuthenticationStatusFluent<A> {

    private List<OperatorConditionBuilder> conditions =  new ArrayList<OperatorConditionBuilder>();
    private List<GenerationStatusBuilder> generations =  new ArrayList<GenerationStatusBuilder>();
    private Boolean managingOAuthAPIServer;
    private OAuthAPIServerStatusBuilder oauthAPIServer;
    private Long observedGeneration;
    private Integer readyReplicas;
    private String version;

    public AuthenticationStatusFluentImpl() { 
    }


    public AuthenticationStatusFluentImpl(AuthenticationStatus instance) { 
        this.withConditions(instance.getConditions()); 
        this.withGenerations(instance.getGenerations()); 
        this.withManagingOAuthAPIServer(instance.getManagingOAuthAPIServer()); 
        this.withOauthAPIServer(instance.getOauthAPIServer()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withReadyReplicas(instance.getReadyReplicas()); 
        this.withVersion(instance.getVersion()); 
    }


    public A addToConditions(int index,OperatorCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
        OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,OperatorCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
        OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(OperatorCondition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
        for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<OperatorCondition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
        for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(OperatorCondition... items) {
        for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<OperatorCondition> items) {
        for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<OperatorConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          OperatorConditionBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<OperatorCondition> getConditions() {
        return build(conditions);
    }

    public List<OperatorCondition> buildConditions() {
        return build(conditions);
    }

    public OperatorCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public OperatorCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public OperatorCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public OperatorCondition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate) {
        for (OperatorConditionBuilder item: conditions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate) {
        for (OperatorConditionBuilder item: conditions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConditions(List<OperatorCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<OperatorConditionBuilder>(); for (OperatorCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(OperatorCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (OperatorCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
        return (A)addToConditions(new OperatorCondition(lastTransitionTime, message, reason, status, type));
    }

    public AuthenticationStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public AuthenticationStatusFluent.ConditionsNested<A> addNewConditionLike(OperatorCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public AuthenticationStatusFluent.ConditionsNested<A> setNewConditionLike(int index,OperatorCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public AuthenticationStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public AuthenticationStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public AuthenticationStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public AuthenticationStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.apply(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public A addToGenerations(int index,GenerationStatus item) {
        if (this.generations == null) {this.generations = new ArrayList<GenerationStatusBuilder>();}
        GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").add(index >= 0 ? index : _visitables.get("generations").size(), builder);this.generations.add(index >= 0 ? index : generations.size(), builder); return (A)this;
    }

    public A setToGenerations(int index,GenerationStatus item) {
        if (this.generations == null) {this.generations = new ArrayList<GenerationStatusBuilder>();}
        GenerationStatusBuilder builder = new GenerationStatusBuilder(item);
        if (index < 0 || index >= _visitables.get("generations").size()) { _visitables.get("generations").add(builder); } else { _visitables.get("generations").set(index, builder);}
        if (index < 0 || index >= generations.size()) { generations.add(builder); } else { generations.set(index, builder);}
         return (A)this;
    }

    public A addToGenerations(GenerationStatus... items) {
        if (this.generations == null) {this.generations = new ArrayList<GenerationStatusBuilder>();}
        for (GenerationStatus item : items) {GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").add(builder);this.generations.add(builder);} return (A)this;
    }

    public A addAllToGenerations(Collection<GenerationStatus> items) {
        if (this.generations == null) {this.generations = new ArrayList<GenerationStatusBuilder>();}
        for (GenerationStatus item : items) {GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").add(builder);this.generations.add(builder);} return (A)this;
    }

    public A removeFromGenerations(GenerationStatus... items) {
        for (GenerationStatus item : items) {GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").remove(builder);if (this.generations != null) {this.generations.remove(builder);}} return (A)this;
    }

    public A removeAllFromGenerations(Collection<GenerationStatus> items) {
        for (GenerationStatus item : items) {GenerationStatusBuilder builder = new GenerationStatusBuilder(item);_visitables.get("generations").remove(builder);if (this.generations != null) {this.generations.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromGenerations(io.fabric8.kubernetes.api.builder.Predicate<GenerationStatusBuilder> predicate) {
        if (generations == null) return (A) this;
        final Iterator<GenerationStatusBuilder> each = generations.iterator();
        final List visitables = _visitables.get("generations");
        while (each.hasNext()) {
          GenerationStatusBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildGenerations instead.
 * @return The buildable object.
 */
@Deprecated public List<GenerationStatus> getGenerations() {
        return build(generations);
    }

    public List<GenerationStatus> buildGenerations() {
        return build(generations);
    }

    public GenerationStatus buildGeneration(int index) {
        return this.generations.get(index).build();
    }

    public GenerationStatus buildFirstGeneration() {
        return this.generations.get(0).build();
    }

    public GenerationStatus buildLastGeneration() {
        return this.generations.get(generations.size() - 1).build();
    }

    public GenerationStatus buildMatchingGeneration(io.fabric8.kubernetes.api.builder.Predicate<GenerationStatusBuilder> predicate) {
        for (GenerationStatusBuilder item: generations) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingGeneration(io.fabric8.kubernetes.api.builder.Predicate<GenerationStatusBuilder> predicate) {
        for (GenerationStatusBuilder item: generations) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withGenerations(List<GenerationStatus> generations) {
        if (this.generations != null) { _visitables.get("generations").removeAll(this.generations);}
        if (generations != null) {this.generations = new ArrayList<GenerationStatusBuilder>(); for (GenerationStatus item : generations){this.addToGenerations(item);}} else { this.generations = null;} return (A) this;
    }

    public A withGenerations(GenerationStatus... generations) {
        if (this.generations != null) {this.generations.clear();}
        if (generations != null) {for (GenerationStatus item :generations){ this.addToGenerations(item);}} return (A) this;
    }

    public Boolean hasGenerations() {
        return generations != null && !generations.isEmpty();
    }

    public AuthenticationStatusFluent.GenerationsNested<A> addNewGeneration() {
        return new GenerationsNestedImpl();
    }

    public AuthenticationStatusFluent.GenerationsNested<A> addNewGenerationLike(GenerationStatus item) {
        return new GenerationsNestedImpl(-1, item);
    }

    public AuthenticationStatusFluent.GenerationsNested<A> setNewGenerationLike(int index,GenerationStatus item) {
        return new GenerationsNestedImpl(index, item);
    }

    public AuthenticationStatusFluent.GenerationsNested<A> editGeneration(int index) {
        if (generations.size() <= index) throw new RuntimeException("Can't edit generations. Index exceeds size.");
        return setNewGenerationLike(index, buildGeneration(index));
    }

    public AuthenticationStatusFluent.GenerationsNested<A> editFirstGeneration() {
        if (generations.size() == 0) throw new RuntimeException("Can't edit first generations. The list is empty.");
        return setNewGenerationLike(0, buildGeneration(0));
    }

    public AuthenticationStatusFluent.GenerationsNested<A> editLastGeneration() {
        int index = generations.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last generations. The list is empty.");
        return setNewGenerationLike(index, buildGeneration(index));
    }

    public AuthenticationStatusFluent.GenerationsNested<A> editMatchingGeneration(io.fabric8.kubernetes.api.builder.Predicate<GenerationStatusBuilder> predicate) {
        int index = -1;
        for (int i=0;i<generations.size();i++) { 
        if (predicate.apply(generations.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching generations. No match found.");
        return setNewGenerationLike(index, buildGeneration(index));
    }

    public Boolean isManagingOAuthAPIServer() {
        return this.managingOAuthAPIServer;
    }

    public A withManagingOAuthAPIServer(Boolean managingOAuthAPIServer) {
        this.managingOAuthAPIServer=managingOAuthAPIServer; return (A) this;
    }

    public Boolean hasManagingOAuthAPIServer() {
        return this.managingOAuthAPIServer != null;
    }

    public A withNewManagingOAuthAPIServer(String arg1) {
        return (A)withManagingOAuthAPIServer(new Boolean(arg1));
    }

    public A withNewManagingOAuthAPIServer(boolean arg1) {
        return (A)withManagingOAuthAPIServer(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildOauthAPIServer instead.
 * @return The buildable object.
 */
@Deprecated public OAuthAPIServerStatus getOauthAPIServer() {
        return this.oauthAPIServer!=null?this.oauthAPIServer.build():null;
    }

    public OAuthAPIServerStatus buildOauthAPIServer() {
        return this.oauthAPIServer!=null?this.oauthAPIServer.build():null;
    }

    public A withOauthAPIServer(OAuthAPIServerStatus oauthAPIServer) {
        _visitables.get("oauthAPIServer").remove(this.oauthAPIServer);
        if (oauthAPIServer!=null){ this.oauthAPIServer= new OAuthAPIServerStatusBuilder(oauthAPIServer); _visitables.get("oauthAPIServer").add(this.oauthAPIServer);} return (A) this;
    }

    public Boolean hasOauthAPIServer() {
        return this.oauthAPIServer != null;
    }

    public A withNewOauthAPIServer(Integer latestAvailableRevision) {
        return (A)withOauthAPIServer(new OAuthAPIServerStatus(latestAvailableRevision));
    }

    public AuthenticationStatusFluent.OauthAPIServerNested<A> withNewOauthAPIServer() {
        return new OauthAPIServerNestedImpl();
    }

    public AuthenticationStatusFluent.OauthAPIServerNested<A> withNewOauthAPIServerLike(OAuthAPIServerStatus item) {
        return new OauthAPIServerNestedImpl(item);
    }

    public AuthenticationStatusFluent.OauthAPIServerNested<A> editOauthAPIServer() {
        return withNewOauthAPIServerLike(getOauthAPIServer());
    }

    public AuthenticationStatusFluent.OauthAPIServerNested<A> editOrNewOauthAPIServer() {
        return withNewOauthAPIServerLike(getOauthAPIServer() != null ? getOauthAPIServer(): new OAuthAPIServerStatusBuilder().build());
    }

    public AuthenticationStatusFluent.OauthAPIServerNested<A> editOrNewOauthAPIServerLike(OAuthAPIServerStatus item) {
        return withNewOauthAPIServerLike(getOauthAPIServer() != null ? getOauthAPIServer(): item);
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    public A withReadyReplicas(Integer readyReplicas) {
        this.readyReplicas=readyReplicas; return (A) this;
    }

    public Boolean hasReadyReplicas() {
        return this.readyReplicas != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version=version; return (A) this;
    }

    public Boolean hasVersion() {
        return this.version != null;
    }

    public A withNewVersion(String arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuilder arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1) {
        return (A)withVersion(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AuthenticationStatusFluentImpl that = (AuthenticationStatusFluentImpl) o;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (generations != null ? !generations.equals(that.generations) :that.generations != null) return false;
        if (managingOAuthAPIServer != null ? !managingOAuthAPIServer.equals(that.managingOAuthAPIServer) :that.managingOAuthAPIServer != null) return false;
        if (oauthAPIServer != null ? !oauthAPIServer.equals(that.oauthAPIServer) :that.oauthAPIServer != null) return false;
        if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
        if (readyReplicas != null ? !readyReplicas.equals(that.readyReplicas) :that.readyReplicas != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(conditions,  generations,  managingOAuthAPIServer,  oauthAPIServer,  observedGeneration,  readyReplicas,  version,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends OperatorConditionFluentImpl<AuthenticationStatusFluent.ConditionsNested<N>> implements AuthenticationStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OperatorConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index,OperatorCondition item) {
            this.index = index;
            this.builder = new OperatorConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new OperatorConditionBuilder(this);
        }

        public N and() {
             return (N) AuthenticationStatusFluentImpl.this.setToConditions(index,builder.build());
        }

        public N endCondition() {
             return and();
        }
    }


    public class GenerationsNestedImpl<N> extends GenerationStatusFluentImpl<AuthenticationStatusFluent.GenerationsNested<N>> implements AuthenticationStatusFluent.GenerationsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GenerationStatusBuilder builder;
        private final int index;

        GenerationsNestedImpl(int index,GenerationStatus item) {
            this.index = index;
            this.builder = new GenerationStatusBuilder(this, item);
        }

        GenerationsNestedImpl() {
            this.index = -1;
            this.builder = new GenerationStatusBuilder(this);
        }

        public N and() {
             return (N) AuthenticationStatusFluentImpl.this.setToGenerations(index,builder.build());
        }

        public N endGeneration() {
             return and();
        }
    }


    public class OauthAPIServerNestedImpl<N> extends OAuthAPIServerStatusFluentImpl<AuthenticationStatusFluent.OauthAPIServerNested<N>> implements AuthenticationStatusFluent.OauthAPIServerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OAuthAPIServerStatusBuilder builder;

        OauthAPIServerNestedImpl(OAuthAPIServerStatus item) {
            this.builder = new OAuthAPIServerStatusBuilder(this, item);
        }

        OauthAPIServerNestedImpl() {
            this.builder = new OAuthAPIServerStatusBuilder(this);
        }

        public N and() {
             return (N) AuthenticationStatusFluentImpl.this.withOauthAPIServer(builder.build());
        }

        public N endOauthAPIServer() {
             return and();
        }
    }


}
