package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AuthenticationSpecBuilder extends AuthenticationSpecFluentImpl<AuthenticationSpecBuilder> implements VisitableBuilder<AuthenticationSpec,AuthenticationSpecBuilder> {

    AuthenticationSpecFluent<?> fluent;
    Boolean validationEnabled;

    public AuthenticationSpecBuilder() { 
        this(true);
    }


    public AuthenticationSpecBuilder(Boolean validationEnabled) { 
        this(new AuthenticationSpec(), validationEnabled);
    }


    public AuthenticationSpecBuilder(AuthenticationSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public AuthenticationSpecBuilder(AuthenticationSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new AuthenticationSpec(), validationEnabled);
    }


    public AuthenticationSpecBuilder(AuthenticationSpecFluent<?> fluent,AuthenticationSpec instance) { 
        this(fluent, instance, true);
    }


    public AuthenticationSpecBuilder(AuthenticationSpecFluent<?> fluent,AuthenticationSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withLogLevel(instance.getLogLevel()); 
        fluent.withManagementState(instance.getManagementState()); 
        fluent.withObservedConfig(instance.getObservedConfig()); 
        fluent.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
        this.validationEnabled = validationEnabled; 
    }


    public AuthenticationSpecBuilder(AuthenticationSpec instance) { 
        this(instance,true);
    }


    public AuthenticationSpecBuilder(AuthenticationSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withLogLevel(instance.getLogLevel()); 
        this.withManagementState(instance.getManagementState()); 
        this.withObservedConfig(instance.getObservedConfig()); 
        this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
        this.validationEnabled = validationEnabled; 
    }


    public AuthenticationSpec build() {
        AuthenticationSpec buildable = new AuthenticationSpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getUnsupportedConfigOverrides());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AuthenticationSpecBuilder that = (AuthenticationSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
