package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AdditionalNetworkDefinitionBuilder extends AdditionalNetworkDefinitionFluentImpl<AdditionalNetworkDefinitionBuilder> implements VisitableBuilder<AdditionalNetworkDefinition,AdditionalNetworkDefinitionBuilder> {

    AdditionalNetworkDefinitionFluent<?> fluent;
    Boolean validationEnabled;

    public AdditionalNetworkDefinitionBuilder() { 
        this(true);
    }


    public AdditionalNetworkDefinitionBuilder(Boolean validationEnabled) { 
        this(new AdditionalNetworkDefinition(), validationEnabled);
    }


    public AdditionalNetworkDefinitionBuilder(AdditionalNetworkDefinitionFluent<?> fluent) { 
        this(fluent, true);
    }


    public AdditionalNetworkDefinitionBuilder(AdditionalNetworkDefinitionFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new AdditionalNetworkDefinition(), validationEnabled);
    }


    public AdditionalNetworkDefinitionBuilder(AdditionalNetworkDefinitionFluent<?> fluent,AdditionalNetworkDefinition instance) { 
        this(fluent, instance, true);
    }


    public AdditionalNetworkDefinitionBuilder(AdditionalNetworkDefinitionFluent<?> fluent,AdditionalNetworkDefinition instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withName(instance.getName()); 
        fluent.withNamespace(instance.getNamespace()); 
        fluent.withRawCNIConfig(instance.getRawCNIConfig()); 
        fluent.withSimpleMacvlanConfig(instance.getSimpleMacvlanConfig()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }


    public AdditionalNetworkDefinitionBuilder(AdditionalNetworkDefinition instance) { 
        this(instance,true);
    }


    public AdditionalNetworkDefinitionBuilder(AdditionalNetworkDefinition instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withName(instance.getName()); 
        this.withNamespace(instance.getNamespace()); 
        this.withRawCNIConfig(instance.getRawCNIConfig()); 
        this.withSimpleMacvlanConfig(instance.getSimpleMacvlanConfig()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }


    public AdditionalNetworkDefinition build() {
        AdditionalNetworkDefinition buildable = new AdditionalNetworkDefinition(fluent.getName(),fluent.getNamespace(),fluent.getRawCNIConfig(),fluent.getSimpleMacvlanConfig(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AdditionalNetworkDefinitionBuilder that = (AdditionalNetworkDefinitionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
