package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceCABuilder extends ServiceCAFluentImpl<ServiceCABuilder> implements VisitableBuilder<ServiceCA,ServiceCABuilder> {

    ServiceCAFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceCABuilder() { 
        this(true);
    }


    public ServiceCABuilder(Boolean validationEnabled) { 
        this(new ServiceCA(), validationEnabled);
    }


    public ServiceCABuilder(ServiceCAFluent<?> fluent) { 
        this(fluent, true);
    }


    public ServiceCABuilder(ServiceCAFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ServiceCA(), validationEnabled);
    }


    public ServiceCABuilder(ServiceCAFluent<?> fluent,ServiceCA instance) { 
        this(fluent, instance, true);
    }


    public ServiceCABuilder(ServiceCAFluent<?> fluent,ServiceCA instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public ServiceCABuilder(ServiceCA instance) { 
        this(instance,true);
    }


    public ServiceCABuilder(ServiceCA instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public ServiceCA build() {
        ServiceCA buildable = new ServiceCA(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceCABuilder that = (ServiceCABuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
