package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ImagePrunerStatusFluentImpl<A extends ImagePrunerStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ImagePrunerStatusFluent<A> {

    private List<OperatorConditionBuilder> conditions =  new ArrayList<OperatorConditionBuilder>();
    private Long observedGeneration;

    public ImagePrunerStatusFluentImpl() { 
    }


    public ImagePrunerStatusFluentImpl(ImagePrunerStatus instance) { 
        this.withConditions(instance.getConditions()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
    }


    public A addToConditions(int index,OperatorCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
        OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,OperatorCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
        OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(OperatorCondition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
        for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<OperatorCondition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
        for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(OperatorCondition... items) {
        for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<OperatorCondition> items) {
        for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<OperatorConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          OperatorConditionBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<OperatorCondition> getConditions() {
        return build(conditions);
    }

    public List<OperatorCondition> buildConditions() {
        return build(conditions);
    }

    public OperatorCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public OperatorCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public OperatorCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public OperatorCondition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate) {
        for (OperatorConditionBuilder item: conditions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate) {
        for (OperatorConditionBuilder item: conditions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConditions(List<OperatorCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<OperatorConditionBuilder>(); for (OperatorCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(OperatorCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (OperatorCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
        return (A)addToConditions(new OperatorCondition(lastTransitionTime, message, reason, status, type));
    }

    public ImagePrunerStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public ImagePrunerStatusFluent.ConditionsNested<A> addNewConditionLike(OperatorCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public ImagePrunerStatusFluent.ConditionsNested<A> setNewConditionLike(int index,OperatorCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public ImagePrunerStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public ImagePrunerStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public ImagePrunerStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public ImagePrunerStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.apply(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ImagePrunerStatusFluentImpl that = (ImagePrunerStatusFluentImpl) o;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(conditions,  observedGeneration,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends OperatorConditionFluentImpl<ImagePrunerStatusFluent.ConditionsNested<N>> implements ImagePrunerStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OperatorConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index,OperatorCondition item) {
            this.index = index;
            this.builder = new OperatorConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new OperatorConditionBuilder(this);
        }

        public N and() {
             return (N) ImagePrunerStatusFluentImpl.this.setToConditions(index,builder.build());
        }

        public N endCondition() {
             return and();
        }
    }


}
