package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface AuthenticationListFluent<A extends AuthenticationListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Authentication item);
    public A setToItems(int index,Authentication item);
    public A addToItems(Authentication... items);
    public A addAllToItems(Collection<Authentication> items);
    public A removeFromItems(Authentication... items);
    public A removeAllFromItems(Collection<Authentication> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<AuthenticationBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Authentication> getItems();
    public List<Authentication> buildItems();
    public Authentication buildItem(int index);
    public Authentication buildFirstItem();
    public Authentication buildLastItem();
    public Authentication buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<AuthenticationBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<AuthenticationBuilder> predicate);
    public A withItems(List<Authentication> items);
    public A withItems(Authentication... items);
    public Boolean hasItems();
    public AuthenticationListFluent.ItemsNested<A> addNewItem();
    public AuthenticationListFluent.ItemsNested<A> addNewItemLike(Authentication item);
    public AuthenticationListFluent.ItemsNested<A> setNewItemLike(int index,Authentication item);
    public AuthenticationListFluent.ItemsNested<A> editItem(int index);
    public AuthenticationListFluent.ItemsNested<A> editFirstItem();
    public AuthenticationListFluent.ItemsNested<A> editLastItem();
    public AuthenticationListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<AuthenticationBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AuthenticationFluent<AuthenticationListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
