package io.fabric8.openshift.api.model.operator.v1;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class SyslogLoggingDestinationParametersFluentImpl<A extends SyslogLoggingDestinationParametersFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SyslogLoggingDestinationParametersFluent<A>{

    private String address;
    private String facility;
    private Integer port;

    public SyslogLoggingDestinationParametersFluentImpl(){
    }
    public SyslogLoggingDestinationParametersFluentImpl(SyslogLoggingDestinationParameters instance){
            this.withAddress(instance.getAddress()); 
            this.withFacility(instance.getFacility()); 
            this.withPort(instance.getPort()); 
    }

    public String getAddress(){
            return this.address;
    }

    public A withAddress(String address){
            this.address=address; return (A) this;
    }

    public Boolean hasAddress(){
            return this.address != null;
    }

    public A withNewAddress(String arg1){
            return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuilder arg1){
            return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuffer arg1){
            return (A)withAddress(new String(arg1));
    }

    public String getFacility(){
            return this.facility;
    }

    public A withFacility(String facility){
            this.facility=facility; return (A) this;
    }

    public Boolean hasFacility(){
            return this.facility != null;
    }

    public A withNewFacility(String arg1){
            return (A)withFacility(new String(arg1));
    }

    public A withNewFacility(StringBuilder arg1){
            return (A)withFacility(new String(arg1));
    }

    public A withNewFacility(StringBuffer arg1){
            return (A)withFacility(new String(arg1));
    }

    public Integer getPort(){
            return this.port;
    }

    public A withPort(Integer port){
            this.port=port; return (A) this;
    }

    public Boolean hasPort(){
            return this.port != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            SyslogLoggingDestinationParametersFluentImpl that = (SyslogLoggingDestinationParametersFluentImpl) o;
            if (address != null ? !address.equals(that.address) :that.address != null) return false;
            if (facility != null ? !facility.equals(that.facility) :that.facility != null) return false;
            if (port != null ? !port.equals(that.port) :that.port != null) return false;
            return true;
    }




}
