package io.fabric8.openshift.api.model.operator.v1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class StaticIPAMRoutesFluentImpl<A extends StaticIPAMRoutesFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StaticIPAMRoutesFluent<A>{

    private String destination;
    private String gateway;

    public StaticIPAMRoutesFluentImpl(){
    }
    public StaticIPAMRoutesFluentImpl(StaticIPAMRoutes instance){
            this.withDestination(instance.getDestination()); 
            this.withGateway(instance.getGateway()); 
    }

    public String getDestination(){
            return this.destination;
    }

    public A withDestination(String destination){
            this.destination=destination; return (A) this;
    }

    public Boolean hasDestination(){
            return this.destination != null;
    }

    public A withNewDestination(String arg1){
            return (A)withDestination(new String(arg1));
    }

    public A withNewDestination(StringBuilder arg1){
            return (A)withDestination(new String(arg1));
    }

    public A withNewDestination(StringBuffer arg1){
            return (A)withDestination(new String(arg1));
    }

    public String getGateway(){
            return this.gateway;
    }

    public A withGateway(String gateway){
            this.gateway=gateway; return (A) this;
    }

    public Boolean hasGateway(){
            return this.gateway != null;
    }

    public A withNewGateway(String arg1){
            return (A)withGateway(new String(arg1));
    }

    public A withNewGateway(StringBuilder arg1){
            return (A)withGateway(new String(arg1));
    }

    public A withNewGateway(StringBuffer arg1){
            return (A)withGateway(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            StaticIPAMRoutesFluentImpl that = (StaticIPAMRoutesFluentImpl) o;
            if (destination != null ? !destination.equals(that.destination) :that.destination != null) return false;
            if (gateway != null ? !gateway.equals(that.gateway) :that.gateway != null) return false;
            return true;
    }




}
