package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SimpleMacvlanConfigBuilder extends SimpleMacvlanConfigFluentImpl<SimpleMacvlanConfigBuilder> implements VisitableBuilder<SimpleMacvlanConfig,SimpleMacvlanConfigBuilder>{

    SimpleMacvlanConfigFluent<?> fluent;
    Boolean validationEnabled;

    public SimpleMacvlanConfigBuilder(){
            this(true);
    }
    public SimpleMacvlanConfigBuilder(Boolean validationEnabled){
            this(new SimpleMacvlanConfig(), validationEnabled);
    }
    public SimpleMacvlanConfigBuilder(SimpleMacvlanConfigFluent<?> fluent){
            this(fluent, true);
    }
    public SimpleMacvlanConfigBuilder(SimpleMacvlanConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SimpleMacvlanConfig(), validationEnabled);
    }
    public SimpleMacvlanConfigBuilder(SimpleMacvlanConfigFluent<?> fluent,SimpleMacvlanConfig instance){
            this(fluent, instance, true);
    }
    public SimpleMacvlanConfigBuilder(SimpleMacvlanConfigFluent<?> fluent,SimpleMacvlanConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withIpamConfig(instance.getIpamConfig()); 
            fluent.withMaster(instance.getMaster()); 
            fluent.withMode(instance.getMode()); 
            fluent.withMtu(instance.getMtu()); 
            this.validationEnabled = validationEnabled; 
    }
    public SimpleMacvlanConfigBuilder(SimpleMacvlanConfig instance){
            this(instance,true);
    }
    public SimpleMacvlanConfigBuilder(SimpleMacvlanConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withIpamConfig(instance.getIpamConfig()); 
            this.withMaster(instance.getMaster()); 
            this.withMode(instance.getMode()); 
            this.withMtu(instance.getMtu()); 
            this.validationEnabled = validationEnabled; 
    }

    public SimpleMacvlanConfig build(){
            SimpleMacvlanConfig buildable = new SimpleMacvlanConfig(fluent.getIpamConfig(),fluent.getMaster(),fluent.getMode(),fluent.getMtu());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SimpleMacvlanConfigBuilder that = (SimpleMacvlanConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
