package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface OpenShiftControllerManagerListFluent<A extends OpenShiftControllerManagerListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,OpenShiftControllerManager item);
    public A setToItems(int index,OpenShiftControllerManager item);
    public A addToItems(OpenShiftControllerManager... items);
    public A addAllToItems(Collection<OpenShiftControllerManager> items);
    public A removeFromItems(OpenShiftControllerManager... items);
    public A removeAllFromItems(Collection<OpenShiftControllerManager> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<OpenShiftControllerManagerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<OpenShiftControllerManager> getItems();
    public List<OpenShiftControllerManager> buildItems();
    public OpenShiftControllerManager buildItem(int index);
    public OpenShiftControllerManager buildFirstItem();
    public OpenShiftControllerManager buildLastItem();
    public OpenShiftControllerManager buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<OpenShiftControllerManagerBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<OpenShiftControllerManagerBuilder> predicate);
    public A withItems(List<OpenShiftControllerManager> items);
    public A withItems(OpenShiftControllerManager... items);
    public Boolean hasItems();
    public OpenShiftControllerManagerListFluent.ItemsNested<A> addNewItem();
    public OpenShiftControllerManagerListFluent.ItemsNested<A> addNewItemLike(OpenShiftControllerManager item);
    public OpenShiftControllerManagerListFluent.ItemsNested<A> setNewItemLike(int index,OpenShiftControllerManager item);
    public OpenShiftControllerManagerListFluent.ItemsNested<A> editItem(int index);
    public OpenShiftControllerManagerListFluent.ItemsNested<A> editFirstItem();
    public OpenShiftControllerManagerListFluent.ItemsNested<A> editLastItem();
    public OpenShiftControllerManagerListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<OpenShiftControllerManagerBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftControllerManagerFluent<OpenShiftControllerManagerListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
