package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface OpenShiftControllerManagerFluent<A extends OpenShiftControllerManagerFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public OpenShiftControllerManagerFluent.MetadataNested<A> withNewMetadata();
    public OpenShiftControllerManagerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public OpenShiftControllerManagerFluent.MetadataNested<A> editMetadata();
    public OpenShiftControllerManagerFluent.MetadataNested<A> editOrNewMetadata();
    public OpenShiftControllerManagerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public OpenShiftControllerManagerSpec getSpec();
    public OpenShiftControllerManagerSpec buildSpec();
    public A withSpec(OpenShiftControllerManagerSpec spec);
    public Boolean hasSpec();
    public OpenShiftControllerManagerFluent.SpecNested<A> withNewSpec();
    public OpenShiftControllerManagerFluent.SpecNested<A> withNewSpecLike(OpenShiftControllerManagerSpec item);
    public OpenShiftControllerManagerFluent.SpecNested<A> editSpec();
    public OpenShiftControllerManagerFluent.SpecNested<A> editOrNewSpec();
    public OpenShiftControllerManagerFluent.SpecNested<A> editOrNewSpecLike(OpenShiftControllerManagerSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public OpenShiftControllerManagerStatus getStatus();
    public OpenShiftControllerManagerStatus buildStatus();
    public A withStatus(OpenShiftControllerManagerStatus status);
    public Boolean hasStatus();
    public OpenShiftControllerManagerFluent.StatusNested<A> withNewStatus();
    public OpenShiftControllerManagerFluent.StatusNested<A> withNewStatusLike(OpenShiftControllerManagerStatus item);
    public OpenShiftControllerManagerFluent.StatusNested<A> editStatus();
    public OpenShiftControllerManagerFluent.StatusNested<A> editOrNewStatus();
    public OpenShiftControllerManagerFluent.StatusNested<A> editOrNewStatusLike(OpenShiftControllerManagerStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<OpenShiftControllerManagerFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftControllerManagerSpecFluent<OpenShiftControllerManagerFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftControllerManagerStatusFluent<OpenShiftControllerManagerFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
