package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OpenShiftControllerManagerBuilder extends OpenShiftControllerManagerFluentImpl<OpenShiftControllerManagerBuilder> implements VisitableBuilder<OpenShiftControllerManager,OpenShiftControllerManagerBuilder>{

    OpenShiftControllerManagerFluent<?> fluent;
    Boolean validationEnabled;

    public OpenShiftControllerManagerBuilder(){
            this(true);
    }
    public OpenShiftControllerManagerBuilder(Boolean validationEnabled){
            this(new OpenShiftControllerManager(), validationEnabled);
    }
    public OpenShiftControllerManagerBuilder(OpenShiftControllerManagerFluent<?> fluent){
            this(fluent, true);
    }
    public OpenShiftControllerManagerBuilder(OpenShiftControllerManagerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new OpenShiftControllerManager(), validationEnabled);
    }
    public OpenShiftControllerManagerBuilder(OpenShiftControllerManagerFluent<?> fluent,OpenShiftControllerManager instance){
            this(fluent, instance, true);
    }
    public OpenShiftControllerManagerBuilder(OpenShiftControllerManagerFluent<?> fluent,OpenShiftControllerManager instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public OpenShiftControllerManagerBuilder(OpenShiftControllerManager instance){
            this(instance,true);
    }
    public OpenShiftControllerManagerBuilder(OpenShiftControllerManager instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public OpenShiftControllerManager build(){
            OpenShiftControllerManager buildable = new OpenShiftControllerManager(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OpenShiftControllerManagerBuilder that = (OpenShiftControllerManagerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
