package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OpenShiftAPIServerListBuilder extends OpenShiftAPIServerListFluentImpl<OpenShiftAPIServerListBuilder> implements VisitableBuilder<OpenShiftAPIServerList,OpenShiftAPIServerListBuilder>{

    OpenShiftAPIServerListFluent<?> fluent;
    Boolean validationEnabled;

    public OpenShiftAPIServerListBuilder(){
            this(true);
    }
    public OpenShiftAPIServerListBuilder(Boolean validationEnabled){
            this(new OpenShiftAPIServerList(), validationEnabled);
    }
    public OpenShiftAPIServerListBuilder(OpenShiftAPIServerListFluent<?> fluent){
            this(fluent, true);
    }
    public OpenShiftAPIServerListBuilder(OpenShiftAPIServerListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new OpenShiftAPIServerList(), validationEnabled);
    }
    public OpenShiftAPIServerListBuilder(OpenShiftAPIServerListFluent<?> fluent,OpenShiftAPIServerList instance){
            this(fluent, instance, true);
    }
    public OpenShiftAPIServerListBuilder(OpenShiftAPIServerListFluent<?> fluent,OpenShiftAPIServerList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public OpenShiftAPIServerListBuilder(OpenShiftAPIServerList instance){
            this(instance,true);
    }
    public OpenShiftAPIServerListBuilder(OpenShiftAPIServerList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public OpenShiftAPIServerList build(){
            OpenShiftAPIServerList buildable = new OpenShiftAPIServerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OpenShiftAPIServerListBuilder that = (OpenShiftAPIServerListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
