package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OpenShiftAPIServerBuilder extends OpenShiftAPIServerFluentImpl<OpenShiftAPIServerBuilder> implements VisitableBuilder<OpenShiftAPIServer,OpenShiftAPIServerBuilder>{

    OpenShiftAPIServerFluent<?> fluent;
    Boolean validationEnabled;

    public OpenShiftAPIServerBuilder(){
            this(true);
    }
    public OpenShiftAPIServerBuilder(Boolean validationEnabled){
            this(new OpenShiftAPIServer(), validationEnabled);
    }
    public OpenShiftAPIServerBuilder(OpenShiftAPIServerFluent<?> fluent){
            this(fluent, true);
    }
    public OpenShiftAPIServerBuilder(OpenShiftAPIServerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new OpenShiftAPIServer(), validationEnabled);
    }
    public OpenShiftAPIServerBuilder(OpenShiftAPIServerFluent<?> fluent,OpenShiftAPIServer instance){
            this(fluent, instance, true);
    }
    public OpenShiftAPIServerBuilder(OpenShiftAPIServerFluent<?> fluent,OpenShiftAPIServer instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public OpenShiftAPIServerBuilder(OpenShiftAPIServer instance){
            this(instance,true);
    }
    public OpenShiftAPIServerBuilder(OpenShiftAPIServer instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public OpenShiftAPIServer build(){
            OpenShiftAPIServer buildable = new OpenShiftAPIServer(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OpenShiftAPIServerBuilder that = (OpenShiftAPIServerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
