package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkSpecBuilder extends NetworkSpecFluentImpl<NetworkSpecBuilder> implements VisitableBuilder<NetworkSpec,NetworkSpecBuilder>{

    NetworkSpecFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkSpecBuilder(){
            this(true);
    }
    public NetworkSpecBuilder(Boolean validationEnabled){
            this(new NetworkSpec(), validationEnabled);
    }
    public NetworkSpecBuilder(NetworkSpecFluent<?> fluent){
            this(fluent, true);
    }
    public NetworkSpecBuilder(NetworkSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NetworkSpec(), validationEnabled);
    }
    public NetworkSpecBuilder(NetworkSpecFluent<?> fluent,NetworkSpec instance){
            this(fluent, instance, true);
    }
    public NetworkSpecBuilder(NetworkSpecFluent<?> fluent,NetworkSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAdditionalNetworks(instance.getAdditionalNetworks()); 
            fluent.withClusterNetwork(instance.getClusterNetwork()); 
            fluent.withDefaultNetwork(instance.getDefaultNetwork()); 
            fluent.withDeployKubeProxy(instance.getDeployKubeProxy()); 
            fluent.withDisableMultiNetwork(instance.getDisableMultiNetwork()); 
            fluent.withKubeProxyConfig(instance.getKubeProxyConfig()); 
            fluent.withLogLevel(instance.getLogLevel()); 
            fluent.withServiceNetwork(instance.getServiceNetwork()); 
            this.validationEnabled = validationEnabled; 
    }
    public NetworkSpecBuilder(NetworkSpec instance){
            this(instance,true);
    }
    public NetworkSpecBuilder(NetworkSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAdditionalNetworks(instance.getAdditionalNetworks()); 
            this.withClusterNetwork(instance.getClusterNetwork()); 
            this.withDefaultNetwork(instance.getDefaultNetwork()); 
            this.withDeployKubeProxy(instance.getDeployKubeProxy()); 
            this.withDisableMultiNetwork(instance.getDisableMultiNetwork()); 
            this.withKubeProxyConfig(instance.getKubeProxyConfig()); 
            this.withLogLevel(instance.getLogLevel()); 
            this.withServiceNetwork(instance.getServiceNetwork()); 
            this.validationEnabled = validationEnabled; 
    }

    public NetworkSpec build(){
            NetworkSpec buildable = new NetworkSpec(fluent.getAdditionalNetworks(),fluent.getClusterNetwork(),fluent.getDefaultNetwork(),fluent.isDeployKubeProxy(),fluent.isDisableMultiNetwork(),fluent.getKubeProxyConfig(),fluent.getLogLevel(),fluent.getServiceNetwork());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetworkSpecBuilder that = (NetworkSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
