package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class LoggingDestinationFluentImpl<A extends LoggingDestinationFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements LoggingDestinationFluent<A>{

    private ContainerLoggingDestinationParametersBuilder container;
    private SyslogLoggingDestinationParametersBuilder syslog;
    private String type;

    public LoggingDestinationFluentImpl(){
    }
    public LoggingDestinationFluentImpl(LoggingDestination instance){
            this.withContainer(instance.getContainer()); 
            this.withSyslog(instance.getSyslog()); 
            this.withType(instance.getType()); 
    }

    
/**
 * This method has been deprecated, please use method buildContainer instead.
 * @return The buildable object.
 */
@Deprecated public ContainerLoggingDestinationParameters getContainer(){
            return this.container!=null?this.container.build():null;
    }

    public ContainerLoggingDestinationParameters buildContainer(){
            return this.container!=null?this.container.build():null;
    }

    public A withContainer(ContainerLoggingDestinationParameters container){
            _visitables.get("container").remove(this.container);
            if (container!=null){ this.container= new ContainerLoggingDestinationParametersBuilder(container); _visitables.get("container").add(this.container);} return (A) this;
    }

    public Boolean hasContainer(){
            return this.container != null;
    }

    public LoggingDestinationFluent.ContainerNested<A> withNewContainer(){
            return new ContainerNestedImpl();
    }

    public LoggingDestinationFluent.ContainerNested<A> withNewContainerLike(ContainerLoggingDestinationParameters item){
            return new ContainerNestedImpl(item);
    }

    public LoggingDestinationFluent.ContainerNested<A> editContainer(){
            return withNewContainerLike(getContainer());
    }

    public LoggingDestinationFluent.ContainerNested<A> editOrNewContainer(){
            return withNewContainerLike(getContainer() != null ? getContainer(): new ContainerLoggingDestinationParametersBuilder().build());
    }

    public LoggingDestinationFluent.ContainerNested<A> editOrNewContainerLike(ContainerLoggingDestinationParameters item){
            return withNewContainerLike(getContainer() != null ? getContainer(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSyslog instead.
 * @return The buildable object.
 */
@Deprecated public SyslogLoggingDestinationParameters getSyslog(){
            return this.syslog!=null?this.syslog.build():null;
    }

    public SyslogLoggingDestinationParameters buildSyslog(){
            return this.syslog!=null?this.syslog.build():null;
    }

    public A withSyslog(SyslogLoggingDestinationParameters syslog){
            _visitables.get("syslog").remove(this.syslog);
            if (syslog!=null){ this.syslog= new SyslogLoggingDestinationParametersBuilder(syslog); _visitables.get("syslog").add(this.syslog);} return (A) this;
    }

    public Boolean hasSyslog(){
            return this.syslog != null;
    }

    public A withNewSyslog(String address,String facility,Integer port){
            return (A)withSyslog(new SyslogLoggingDestinationParameters(address, facility, port));
    }

    public LoggingDestinationFluent.SyslogNested<A> withNewSyslog(){
            return new SyslogNestedImpl();
    }

    public LoggingDestinationFluent.SyslogNested<A> withNewSyslogLike(SyslogLoggingDestinationParameters item){
            return new SyslogNestedImpl(item);
    }

    public LoggingDestinationFluent.SyslogNested<A> editSyslog(){
            return withNewSyslogLike(getSyslog());
    }

    public LoggingDestinationFluent.SyslogNested<A> editOrNewSyslog(){
            return withNewSyslogLike(getSyslog() != null ? getSyslog(): new SyslogLoggingDestinationParametersBuilder().build());
    }

    public LoggingDestinationFluent.SyslogNested<A> editOrNewSyslogLike(SyslogLoggingDestinationParameters item){
            return withNewSyslogLike(getSyslog() != null ? getSyslog(): item);
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public A withNewType(String arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1){
            return (A)withType(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            LoggingDestinationFluentImpl that = (LoggingDestinationFluentImpl) o;
            if (container != null ? !container.equals(that.container) :that.container != null) return false;
            if (syslog != null ? !syslog.equals(that.syslog) :that.syslog != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class ContainerNestedImpl<N> extends ContainerLoggingDestinationParametersFluentImpl<LoggingDestinationFluent.ContainerNested<N>> implements LoggingDestinationFluent.ContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ContainerLoggingDestinationParametersBuilder builder;
    
            ContainerNestedImpl(ContainerLoggingDestinationParameters item){
                    this.builder = new ContainerLoggingDestinationParametersBuilder(this, item);
            }
            ContainerNestedImpl(){
                    this.builder = new ContainerLoggingDestinationParametersBuilder(this);
            }
    
    public N and(){
            return (N) LoggingDestinationFluentImpl.this.withContainer(builder.build());
    }
    public N endContainer(){
            return and();
    }

}
    public class SyslogNestedImpl<N> extends SyslogLoggingDestinationParametersFluentImpl<LoggingDestinationFluent.SyslogNested<N>> implements LoggingDestinationFluent.SyslogNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SyslogLoggingDestinationParametersBuilder builder;
    
            SyslogNestedImpl(SyslogLoggingDestinationParameters item){
                    this.builder = new SyslogLoggingDestinationParametersBuilder(this, item);
            }
            SyslogNestedImpl(){
                    this.builder = new SyslogLoggingDestinationParametersBuilder(this);
            }
    
    public N and(){
            return (N) LoggingDestinationFluentImpl.this.withSyslog(builder.build());
    }
    public N endSyslog(){
            return and();
    }

}


}
