package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubeControllerManagerStatusBuilder extends KubeControllerManagerStatusFluentImpl<KubeControllerManagerStatusBuilder> implements VisitableBuilder<KubeControllerManagerStatus,KubeControllerManagerStatusBuilder>{

    KubeControllerManagerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public KubeControllerManagerStatusBuilder(){
            this(true);
    }
    public KubeControllerManagerStatusBuilder(Boolean validationEnabled){
            this(new KubeControllerManagerStatus(), validationEnabled);
    }
    public KubeControllerManagerStatusBuilder(KubeControllerManagerStatusFluent<?> fluent){
            this(fluent, true);
    }
    public KubeControllerManagerStatusBuilder(KubeControllerManagerStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KubeControllerManagerStatus(), validationEnabled);
    }
    public KubeControllerManagerStatusBuilder(KubeControllerManagerStatusFluent<?> fluent,KubeControllerManagerStatus instance){
            this(fluent, instance, true);
    }
    public KubeControllerManagerStatusBuilder(KubeControllerManagerStatusFluent<?> fluent,KubeControllerManagerStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConditions(instance.getConditions()); 
            fluent.withGenerations(instance.getGenerations()); 
            fluent.withLatestAvailableRevision(instance.getLatestAvailableRevision()); 
            fluent.withLatestAvailableRevisionReason(instance.getLatestAvailableRevisionReason()); 
            fluent.withNodeStatuses(instance.getNodeStatuses()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withReadyReplicas(instance.getReadyReplicas()); 
            fluent.withVersion(instance.getVersion()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubeControllerManagerStatusBuilder(KubeControllerManagerStatus instance){
            this(instance,true);
    }
    public KubeControllerManagerStatusBuilder(KubeControllerManagerStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConditions(instance.getConditions()); 
            this.withGenerations(instance.getGenerations()); 
            this.withLatestAvailableRevision(instance.getLatestAvailableRevision()); 
            this.withLatestAvailableRevisionReason(instance.getLatestAvailableRevisionReason()); 
            this.withNodeStatuses(instance.getNodeStatuses()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withReadyReplicas(instance.getReadyReplicas()); 
            this.withVersion(instance.getVersion()); 
            this.validationEnabled = validationEnabled; 
    }

    public KubeControllerManagerStatus build(){
            KubeControllerManagerStatus buildable = new KubeControllerManagerStatus(fluent.getConditions(),fluent.getGenerations(),fluent.getLatestAvailableRevision(),fluent.getLatestAvailableRevisionReason(),fluent.getNodeStatuses(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubeControllerManagerStatusBuilder that = (KubeControllerManagerStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
