package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressControllerLoggingBuilder extends IngressControllerLoggingFluentImpl<IngressControllerLoggingBuilder> implements VisitableBuilder<IngressControllerLogging,IngressControllerLoggingBuilder>{

    IngressControllerLoggingFluent<?> fluent;
    Boolean validationEnabled;

    public IngressControllerLoggingBuilder(){
            this(true);
    }
    public IngressControllerLoggingBuilder(Boolean validationEnabled){
            this(new IngressControllerLogging(), validationEnabled);
    }
    public IngressControllerLoggingBuilder(IngressControllerLoggingFluent<?> fluent){
            this(fluent, true);
    }
    public IngressControllerLoggingBuilder(IngressControllerLoggingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new IngressControllerLogging(), validationEnabled);
    }
    public IngressControllerLoggingBuilder(IngressControllerLoggingFluent<?> fluent,IngressControllerLogging instance){
            this(fluent, instance, true);
    }
    public IngressControllerLoggingBuilder(IngressControllerLoggingFluent<?> fluent,IngressControllerLogging instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAccess(instance.getAccess()); 
            this.validationEnabled = validationEnabled; 
    }
    public IngressControllerLoggingBuilder(IngressControllerLogging instance){
            this(instance,true);
    }
    public IngressControllerLoggingBuilder(IngressControllerLogging instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAccess(instance.getAccess()); 
            this.validationEnabled = validationEnabled; 
    }

    public IngressControllerLogging build(){
            IngressControllerLogging buildable = new IngressControllerLogging(fluent.getAccess());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IngressControllerLoggingBuilder that = (IngressControllerLoggingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
