package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressControllerHTTPUniqueIdHeaderPolicyBuilder extends IngressControllerHTTPUniqueIdHeaderPolicyFluentImpl<IngressControllerHTTPUniqueIdHeaderPolicyBuilder> implements VisitableBuilder<IngressControllerHTTPUniqueIdHeaderPolicy,IngressControllerHTTPUniqueIdHeaderPolicyBuilder>{

    IngressControllerHTTPUniqueIdHeaderPolicyFluent<?> fluent;
    Boolean validationEnabled;

    public IngressControllerHTTPUniqueIdHeaderPolicyBuilder(){
            this(true);
    }
    public IngressControllerHTTPUniqueIdHeaderPolicyBuilder(Boolean validationEnabled){
            this(new IngressControllerHTTPUniqueIdHeaderPolicy(), validationEnabled);
    }
    public IngressControllerHTTPUniqueIdHeaderPolicyBuilder(IngressControllerHTTPUniqueIdHeaderPolicyFluent<?> fluent){
            this(fluent, true);
    }
    public IngressControllerHTTPUniqueIdHeaderPolicyBuilder(IngressControllerHTTPUniqueIdHeaderPolicyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new IngressControllerHTTPUniqueIdHeaderPolicy(), validationEnabled);
    }
    public IngressControllerHTTPUniqueIdHeaderPolicyBuilder(IngressControllerHTTPUniqueIdHeaderPolicyFluent<?> fluent,IngressControllerHTTPUniqueIdHeaderPolicy instance){
            this(fluent, instance, true);
    }
    public IngressControllerHTTPUniqueIdHeaderPolicyBuilder(IngressControllerHTTPUniqueIdHeaderPolicyFluent<?> fluent,IngressControllerHTTPUniqueIdHeaderPolicy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFormat(instance.getFormat()); 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public IngressControllerHTTPUniqueIdHeaderPolicyBuilder(IngressControllerHTTPUniqueIdHeaderPolicy instance){
            this(instance,true);
    }
    public IngressControllerHTTPUniqueIdHeaderPolicyBuilder(IngressControllerHTTPUniqueIdHeaderPolicy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFormat(instance.getFormat()); 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }

    public IngressControllerHTTPUniqueIdHeaderPolicy build(){
            IngressControllerHTTPUniqueIdHeaderPolicy buildable = new IngressControllerHTTPUniqueIdHeaderPolicy(fluent.getFormat(),fluent.getName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IngressControllerHTTPUniqueIdHeaderPolicyBuilder that = (IngressControllerHTTPUniqueIdHeaderPolicyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
