package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

public class IngressControllerCaptureHTTPHeadersFluentImpl<A extends IngressControllerCaptureHTTPHeadersFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IngressControllerCaptureHTTPHeadersFluent<A>{

    private List<IngressControllerCaptureHTTPHeaderBuilder> request =  new ArrayList<IngressControllerCaptureHTTPHeaderBuilder>();
    private List<IngressControllerCaptureHTTPHeaderBuilder> response =  new ArrayList<IngressControllerCaptureHTTPHeaderBuilder>();

    public IngressControllerCaptureHTTPHeadersFluentImpl(){
    }
    public IngressControllerCaptureHTTPHeadersFluentImpl(IngressControllerCaptureHTTPHeaders instance){
            this.withRequest(instance.getRequest()); 
            this.withResponse(instance.getResponse()); 
    }

    public A addToRequest(int index,IngressControllerCaptureHTTPHeader item){
            if (this.request == null) {this.request = new ArrayList<IngressControllerCaptureHTTPHeaderBuilder>();}
            IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);_visitables.get("request").add(index >= 0 ? index : _visitables.get("request").size(), builder);this.request.add(index >= 0 ? index : request.size(), builder); return (A)this;
    }

    public A setToRequest(int index,IngressControllerCaptureHTTPHeader item){
            if (this.request == null) {this.request = new ArrayList<IngressControllerCaptureHTTPHeaderBuilder>();}
            IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);
            if (index < 0 || index >= _visitables.get("request").size()) { _visitables.get("request").add(builder); } else { _visitables.get("request").set(index, builder);}
            if (index < 0 || index >= request.size()) { request.add(builder); } else { request.set(index, builder);}
             return (A)this;
    }

    public A addToRequest(IngressControllerCaptureHTTPHeader... items){
            if (this.request == null) {this.request = new ArrayList<IngressControllerCaptureHTTPHeaderBuilder>();}
            for (IngressControllerCaptureHTTPHeader item : items) {IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);_visitables.get("request").add(builder);this.request.add(builder);} return (A)this;
    }

    public A addAllToRequest(Collection<IngressControllerCaptureHTTPHeader> items){
            if (this.request == null) {this.request = new ArrayList<IngressControllerCaptureHTTPHeaderBuilder>();}
            for (IngressControllerCaptureHTTPHeader item : items) {IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);_visitables.get("request").add(builder);this.request.add(builder);} return (A)this;
    }

    public A removeFromRequest(IngressControllerCaptureHTTPHeader... items){
            for (IngressControllerCaptureHTTPHeader item : items) {IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);_visitables.get("request").remove(builder);if (this.request != null) {this.request.remove(builder);}} return (A)this;
    }

    public A removeAllFromRequest(Collection<IngressControllerCaptureHTTPHeader> items){
            for (IngressControllerCaptureHTTPHeader item : items) {IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);_visitables.get("request").remove(builder);if (this.request != null) {this.request.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRequest(io.fabric8.kubernetes.api.builder.Predicate<IngressControllerCaptureHTTPHeaderBuilder> predicate){
            if (request == null) return (A) this;
            final Iterator<IngressControllerCaptureHTTPHeaderBuilder> each = request.iterator();
            final List visitables = _visitables.get("request");
            while (each.hasNext()) {
              IngressControllerCaptureHTTPHeaderBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRequest instead.
 * @return The buildable object.
 */
@Deprecated public List<IngressControllerCaptureHTTPHeader> getRequest(){
            return build(request);
    }

    public List<IngressControllerCaptureHTTPHeader> buildRequest(){
            return build(request);
    }

    public IngressControllerCaptureHTTPHeader buildRequest(int index){
            return this.request.get(index).build();
    }

    public IngressControllerCaptureHTTPHeader buildFirstRequest(){
            return this.request.get(0).build();
    }

    public IngressControllerCaptureHTTPHeader buildLastRequest(){
            return this.request.get(request.size() - 1).build();
    }

    public IngressControllerCaptureHTTPHeader buildMatchingRequest(io.fabric8.kubernetes.api.builder.Predicate<IngressControllerCaptureHTTPHeaderBuilder> predicate){
            for (IngressControllerCaptureHTTPHeaderBuilder item: request) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRequest(io.fabric8.kubernetes.api.builder.Predicate<IngressControllerCaptureHTTPHeaderBuilder> predicate){
            for (IngressControllerCaptureHTTPHeaderBuilder item: request) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRequest(List<IngressControllerCaptureHTTPHeader> request){
            if (this.request != null) { _visitables.get("request").removeAll(this.request);}
            if (request != null) {this.request = new ArrayList<IngressControllerCaptureHTTPHeaderBuilder>(); for (IngressControllerCaptureHTTPHeader item : request){this.addToRequest(item);}} else { this.request = null;} return (A) this;
    }

    public A withRequest(IngressControllerCaptureHTTPHeader... request){
            if (this.request != null) {this.request.clear();}
            if (request != null) {for (IngressControllerCaptureHTTPHeader item :request){ this.addToRequest(item);}} return (A) this;
    }

    public Boolean hasRequest(){
            return request != null && !request.isEmpty();
    }

    public A addNewRequest(Integer maxLength,String name){
            return (A)addToRequest(new IngressControllerCaptureHTTPHeader(maxLength, name));
    }

    public IngressControllerCaptureHTTPHeadersFluent.RequestNested<A> addNewRequest(){
            return new RequestNestedImpl();
    }

    public IngressControllerCaptureHTTPHeadersFluent.RequestNested<A> addNewRequestLike(IngressControllerCaptureHTTPHeader item){
            return new RequestNestedImpl(-1, item);
    }

    public IngressControllerCaptureHTTPHeadersFluent.RequestNested<A> setNewRequestLike(int index,IngressControllerCaptureHTTPHeader item){
            return new RequestNestedImpl(index, item);
    }

    public IngressControllerCaptureHTTPHeadersFluent.RequestNested<A> editRequest(int index){
            if (request.size() <= index) throw new RuntimeException("Can't edit request. Index exceeds size.");
            return setNewRequestLike(index, buildRequest(index));
    }

    public IngressControllerCaptureHTTPHeadersFluent.RequestNested<A> editFirstRequest(){
            if (request.size() == 0) throw new RuntimeException("Can't edit first request. The list is empty.");
            return setNewRequestLike(0, buildRequest(0));
    }

    public IngressControllerCaptureHTTPHeadersFluent.RequestNested<A> editLastRequest(){
            int index = request.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last request. The list is empty.");
            return setNewRequestLike(index, buildRequest(index));
    }

    public IngressControllerCaptureHTTPHeadersFluent.RequestNested<A> editMatchingRequest(io.fabric8.kubernetes.api.builder.Predicate<IngressControllerCaptureHTTPHeaderBuilder> predicate){
            int index = -1;
            for (int i=0;i<request.size();i++) { 
            if (predicate.apply(request.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching request. No match found.");
            return setNewRequestLike(index, buildRequest(index));
    }

    public A addToResponse(int index,IngressControllerCaptureHTTPHeader item){
            if (this.response == null) {this.response = new ArrayList<IngressControllerCaptureHTTPHeaderBuilder>();}
            IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);_visitables.get("response").add(index >= 0 ? index : _visitables.get("response").size(), builder);this.response.add(index >= 0 ? index : response.size(), builder); return (A)this;
    }

    public A setToResponse(int index,IngressControllerCaptureHTTPHeader item){
            if (this.response == null) {this.response = new ArrayList<IngressControllerCaptureHTTPHeaderBuilder>();}
            IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);
            if (index < 0 || index >= _visitables.get("response").size()) { _visitables.get("response").add(builder); } else { _visitables.get("response").set(index, builder);}
            if (index < 0 || index >= response.size()) { response.add(builder); } else { response.set(index, builder);}
             return (A)this;
    }

    public A addToResponse(IngressControllerCaptureHTTPHeader... items){
            if (this.response == null) {this.response = new ArrayList<IngressControllerCaptureHTTPHeaderBuilder>();}
            for (IngressControllerCaptureHTTPHeader item : items) {IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);_visitables.get("response").add(builder);this.response.add(builder);} return (A)this;
    }

    public A addAllToResponse(Collection<IngressControllerCaptureHTTPHeader> items){
            if (this.response == null) {this.response = new ArrayList<IngressControllerCaptureHTTPHeaderBuilder>();}
            for (IngressControllerCaptureHTTPHeader item : items) {IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);_visitables.get("response").add(builder);this.response.add(builder);} return (A)this;
    }

    public A removeFromResponse(IngressControllerCaptureHTTPHeader... items){
            for (IngressControllerCaptureHTTPHeader item : items) {IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);_visitables.get("response").remove(builder);if (this.response != null) {this.response.remove(builder);}} return (A)this;
    }

    public A removeAllFromResponse(Collection<IngressControllerCaptureHTTPHeader> items){
            for (IngressControllerCaptureHTTPHeader item : items) {IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);_visitables.get("response").remove(builder);if (this.response != null) {this.response.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromResponse(io.fabric8.kubernetes.api.builder.Predicate<IngressControllerCaptureHTTPHeaderBuilder> predicate){
            if (response == null) return (A) this;
            final Iterator<IngressControllerCaptureHTTPHeaderBuilder> each = response.iterator();
            final List visitables = _visitables.get("response");
            while (each.hasNext()) {
              IngressControllerCaptureHTTPHeaderBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildResponse instead.
 * @return The buildable object.
 */
@Deprecated public List<IngressControllerCaptureHTTPHeader> getResponse(){
            return build(response);
    }

    public List<IngressControllerCaptureHTTPHeader> buildResponse(){
            return build(response);
    }

    public IngressControllerCaptureHTTPHeader buildResponse(int index){
            return this.response.get(index).build();
    }

    public IngressControllerCaptureHTTPHeader buildFirstResponse(){
            return this.response.get(0).build();
    }

    public IngressControllerCaptureHTTPHeader buildLastResponse(){
            return this.response.get(response.size() - 1).build();
    }

    public IngressControllerCaptureHTTPHeader buildMatchingResponse(io.fabric8.kubernetes.api.builder.Predicate<IngressControllerCaptureHTTPHeaderBuilder> predicate){
            for (IngressControllerCaptureHTTPHeaderBuilder item: response) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingResponse(io.fabric8.kubernetes.api.builder.Predicate<IngressControllerCaptureHTTPHeaderBuilder> predicate){
            for (IngressControllerCaptureHTTPHeaderBuilder item: response) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withResponse(List<IngressControllerCaptureHTTPHeader> response){
            if (this.response != null) { _visitables.get("response").removeAll(this.response);}
            if (response != null) {this.response = new ArrayList<IngressControllerCaptureHTTPHeaderBuilder>(); for (IngressControllerCaptureHTTPHeader item : response){this.addToResponse(item);}} else { this.response = null;} return (A) this;
    }

    public A withResponse(IngressControllerCaptureHTTPHeader... response){
            if (this.response != null) {this.response.clear();}
            if (response != null) {for (IngressControllerCaptureHTTPHeader item :response){ this.addToResponse(item);}} return (A) this;
    }

    public Boolean hasResponse(){
            return response != null && !response.isEmpty();
    }

    public A addNewResponse(Integer maxLength,String name){
            return (A)addToResponse(new IngressControllerCaptureHTTPHeader(maxLength, name));
    }

    public IngressControllerCaptureHTTPHeadersFluent.ResponseNested<A> addNewResponse(){
            return new ResponseNestedImpl();
    }

    public IngressControllerCaptureHTTPHeadersFluent.ResponseNested<A> addNewResponseLike(IngressControllerCaptureHTTPHeader item){
            return new ResponseNestedImpl(-1, item);
    }

    public IngressControllerCaptureHTTPHeadersFluent.ResponseNested<A> setNewResponseLike(int index,IngressControllerCaptureHTTPHeader item){
            return new ResponseNestedImpl(index, item);
    }

    public IngressControllerCaptureHTTPHeadersFluent.ResponseNested<A> editResponse(int index){
            if (response.size() <= index) throw new RuntimeException("Can't edit response. Index exceeds size.");
            return setNewResponseLike(index, buildResponse(index));
    }

    public IngressControllerCaptureHTTPHeadersFluent.ResponseNested<A> editFirstResponse(){
            if (response.size() == 0) throw new RuntimeException("Can't edit first response. The list is empty.");
            return setNewResponseLike(0, buildResponse(0));
    }

    public IngressControllerCaptureHTTPHeadersFluent.ResponseNested<A> editLastResponse(){
            int index = response.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last response. The list is empty.");
            return setNewResponseLike(index, buildResponse(index));
    }

    public IngressControllerCaptureHTTPHeadersFluent.ResponseNested<A> editMatchingResponse(io.fabric8.kubernetes.api.builder.Predicate<IngressControllerCaptureHTTPHeaderBuilder> predicate){
            int index = -1;
            for (int i=0;i<response.size();i++) { 
            if (predicate.apply(response.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching response. No match found.");
            return setNewResponseLike(index, buildResponse(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            IngressControllerCaptureHTTPHeadersFluentImpl that = (IngressControllerCaptureHTTPHeadersFluentImpl) o;
            if (request != null ? !request.equals(that.request) :that.request != null) return false;
            if (response != null ? !response.equals(that.response) :that.response != null) return false;
            return true;
    }


    public class RequestNestedImpl<N> extends IngressControllerCaptureHTTPHeaderFluentImpl<IngressControllerCaptureHTTPHeadersFluent.RequestNested<N>> implements IngressControllerCaptureHTTPHeadersFluent.RequestNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IngressControllerCaptureHTTPHeaderBuilder builder;
        private final int index;
    
            RequestNestedImpl(int index,IngressControllerCaptureHTTPHeader item){
                    this.index = index;
                    this.builder = new IngressControllerCaptureHTTPHeaderBuilder(this, item);
            }
            RequestNestedImpl(){
                    this.index = -1;
                    this.builder = new IngressControllerCaptureHTTPHeaderBuilder(this);
            }
    
    public N and(){
            return (N) IngressControllerCaptureHTTPHeadersFluentImpl.this.setToRequest(index,builder.build());
    }
    public N endRequest(){
            return and();
    }

}
    public class ResponseNestedImpl<N> extends IngressControllerCaptureHTTPHeaderFluentImpl<IngressControllerCaptureHTTPHeadersFluent.ResponseNested<N>> implements IngressControllerCaptureHTTPHeadersFluent.ResponseNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IngressControllerCaptureHTTPHeaderBuilder builder;
        private final int index;
    
            ResponseNestedImpl(int index,IngressControllerCaptureHTTPHeader item){
                    this.index = index;
                    this.builder = new IngressControllerCaptureHTTPHeaderBuilder(this, item);
            }
            ResponseNestedImpl(){
                    this.index = -1;
                    this.builder = new IngressControllerCaptureHTTPHeaderBuilder(this);
            }
    
    public N and(){
            return (N) IngressControllerCaptureHTTPHeadersFluentImpl.this.setToResponse(index,builder.build());
    }
    public N endResponse(){
            return and();
    }

}


}
