package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressControllerCaptureHTTPHeadersBuilder extends IngressControllerCaptureHTTPHeadersFluentImpl<IngressControllerCaptureHTTPHeadersBuilder> implements VisitableBuilder<IngressControllerCaptureHTTPHeaders,IngressControllerCaptureHTTPHeadersBuilder>{

    IngressControllerCaptureHTTPHeadersFluent<?> fluent;
    Boolean validationEnabled;

    public IngressControllerCaptureHTTPHeadersBuilder(){
            this(true);
    }
    public IngressControllerCaptureHTTPHeadersBuilder(Boolean validationEnabled){
            this(new IngressControllerCaptureHTTPHeaders(), validationEnabled);
    }
    public IngressControllerCaptureHTTPHeadersBuilder(IngressControllerCaptureHTTPHeadersFluent<?> fluent){
            this(fluent, true);
    }
    public IngressControllerCaptureHTTPHeadersBuilder(IngressControllerCaptureHTTPHeadersFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new IngressControllerCaptureHTTPHeaders(), validationEnabled);
    }
    public IngressControllerCaptureHTTPHeadersBuilder(IngressControllerCaptureHTTPHeadersFluent<?> fluent,IngressControllerCaptureHTTPHeaders instance){
            this(fluent, instance, true);
    }
    public IngressControllerCaptureHTTPHeadersBuilder(IngressControllerCaptureHTTPHeadersFluent<?> fluent,IngressControllerCaptureHTTPHeaders instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRequest(instance.getRequest()); 
            fluent.withResponse(instance.getResponse()); 
            this.validationEnabled = validationEnabled; 
    }
    public IngressControllerCaptureHTTPHeadersBuilder(IngressControllerCaptureHTTPHeaders instance){
            this(instance,true);
    }
    public IngressControllerCaptureHTTPHeadersBuilder(IngressControllerCaptureHTTPHeaders instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRequest(instance.getRequest()); 
            this.withResponse(instance.getResponse()); 
            this.validationEnabled = validationEnabled; 
    }

    public IngressControllerCaptureHTTPHeaders build(){
            IngressControllerCaptureHTTPHeaders buildable = new IngressControllerCaptureHTTPHeaders(fluent.getRequest(),fluent.getResponse());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IngressControllerCaptureHTTPHeadersBuilder that = (IngressControllerCaptureHTTPHeadersBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
