package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface HybridOverlayConfigFluent<A extends HybridOverlayConfigFluent<A>> extends Fluent<A>{


    public A addToHybridClusterNetwork(int index,ClusterNetworkEntry item);
    public A setToHybridClusterNetwork(int index,ClusterNetworkEntry item);
    public A addToHybridClusterNetwork(ClusterNetworkEntry... items);
    public A addAllToHybridClusterNetwork(Collection<ClusterNetworkEntry> items);
    public A removeFromHybridClusterNetwork(ClusterNetworkEntry... items);
    public A removeAllFromHybridClusterNetwork(Collection<ClusterNetworkEntry> items);
    public A removeMatchingFromHybridClusterNetwork(io.fabric8.kubernetes.api.builder.Predicate<ClusterNetworkEntryBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildHybridClusterNetwork instead.
 * @return The buildable object.
 */
@Deprecated public List<ClusterNetworkEntry> getHybridClusterNetwork();
    public List<ClusterNetworkEntry> buildHybridClusterNetwork();
    public ClusterNetworkEntry buildHybridClusterNetwork(int index);
    public ClusterNetworkEntry buildFirstHybridClusterNetwork();
    public ClusterNetworkEntry buildLastHybridClusterNetwork();
    public ClusterNetworkEntry buildMatchingHybridClusterNetwork(io.fabric8.kubernetes.api.builder.Predicate<ClusterNetworkEntryBuilder> predicate);
    public Boolean hasMatchingHybridClusterNetwork(io.fabric8.kubernetes.api.builder.Predicate<ClusterNetworkEntryBuilder> predicate);
    public A withHybridClusterNetwork(List<ClusterNetworkEntry> hybridClusterNetwork);
    public A withHybridClusterNetwork(ClusterNetworkEntry... hybridClusterNetwork);
    public Boolean hasHybridClusterNetwork();
    public A addNewHybridClusterNetwork(String cidr,Integer hostPrefix);
    public HybridOverlayConfigFluent.HybridClusterNetworkNested<A> addNewHybridClusterNetwork();
    public HybridOverlayConfigFluent.HybridClusterNetworkNested<A> addNewHybridClusterNetworkLike(ClusterNetworkEntry item);
    public HybridOverlayConfigFluent.HybridClusterNetworkNested<A> setNewHybridClusterNetworkLike(int index,ClusterNetworkEntry item);
    public HybridOverlayConfigFluent.HybridClusterNetworkNested<A> editHybridClusterNetwork(int index);
    public HybridOverlayConfigFluent.HybridClusterNetworkNested<A> editFirstHybridClusterNetwork();
    public HybridOverlayConfigFluent.HybridClusterNetworkNested<A> editLastHybridClusterNetwork();
    public HybridOverlayConfigFluent.HybridClusterNetworkNested<A> editMatchingHybridClusterNetwork(io.fabric8.kubernetes.api.builder.Predicate<ClusterNetworkEntryBuilder> predicate);
    public Integer getHybridOverlayVXLANPort();
    public A withHybridOverlayVXLANPort(Integer hybridOverlayVXLANPort);
    public Boolean hasHybridOverlayVXLANPort();

    public interface HybridClusterNetworkNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterNetworkEntryFluent<HybridOverlayConfigFluent.HybridClusterNetworkNested<N>>{

        
    public N and();    public N endHybridClusterNetwork();
}


}
