package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class DNSSpecFluentImpl<A extends DNSSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DNSSpecFluent<A>{

    private List<ServerBuilder> servers =  new ArrayList<ServerBuilder>();

    public DNSSpecFluentImpl(){
    }
    public DNSSpecFluentImpl(DNSSpec instance){
            this.withServers(instance.getServers()); 
    }

    public A addToServers(int index,Server item){
            if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
            ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").add(index >= 0 ? index : _visitables.get("servers").size(), builder);this.servers.add(index >= 0 ? index : servers.size(), builder); return (A)this;
    }

    public A setToServers(int index,Server item){
            if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
            ServerBuilder builder = new ServerBuilder(item);
            if (index < 0 || index >= _visitables.get("servers").size()) { _visitables.get("servers").add(builder); } else { _visitables.get("servers").set(index, builder);}
            if (index < 0 || index >= servers.size()) { servers.add(builder); } else { servers.set(index, builder);}
             return (A)this;
    }

    public A addToServers(Server... items){
            if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
            for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").add(builder);this.servers.add(builder);} return (A)this;
    }

    public A addAllToServers(Collection<Server> items){
            if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
            for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").add(builder);this.servers.add(builder);} return (A)this;
    }

    public A removeFromServers(Server... items){
            for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").remove(builder);if (this.servers != null) {this.servers.remove(builder);}} return (A)this;
    }

    public A removeAllFromServers(Collection<Server> items){
            for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").remove(builder);if (this.servers != null) {this.servers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromServers(io.fabric8.kubernetes.api.builder.Predicate<ServerBuilder> predicate){
            if (servers == null) return (A) this;
            final Iterator<ServerBuilder> each = servers.iterator();
            final List visitables = _visitables.get("servers");
            while (each.hasNext()) {
              ServerBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildServers instead.
 * @return The buildable object.
 */
@Deprecated public List<Server> getServers(){
            return build(servers);
    }

    public List<Server> buildServers(){
            return build(servers);
    }

    public Server buildServer(int index){
            return this.servers.get(index).build();
    }

    public Server buildFirstServer(){
            return this.servers.get(0).build();
    }

    public Server buildLastServer(){
            return this.servers.get(servers.size() - 1).build();
    }

    public Server buildMatchingServer(io.fabric8.kubernetes.api.builder.Predicate<ServerBuilder> predicate){
            for (ServerBuilder item: servers) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingServer(io.fabric8.kubernetes.api.builder.Predicate<ServerBuilder> predicate){
            for (ServerBuilder item: servers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withServers(List<Server> servers){
            if (this.servers != null) { _visitables.get("servers").removeAll(this.servers);}
            if (servers != null) {this.servers = new ArrayList<ServerBuilder>(); for (Server item : servers){this.addToServers(item);}} else { this.servers = null;} return (A) this;
    }

    public A withServers(Server... servers){
            if (this.servers != null) {this.servers.clear();}
            if (servers != null) {for (Server item :servers){ this.addToServers(item);}} return (A) this;
    }

    public Boolean hasServers(){
            return servers != null && !servers.isEmpty();
    }

    public DNSSpecFluent.ServersNested<A> addNewServer(){
            return new ServersNestedImpl();
    }

    public DNSSpecFluent.ServersNested<A> addNewServerLike(Server item){
            return new ServersNestedImpl(-1, item);
    }

    public DNSSpecFluent.ServersNested<A> setNewServerLike(int index,Server item){
            return new ServersNestedImpl(index, item);
    }

    public DNSSpecFluent.ServersNested<A> editServer(int index){
            if (servers.size() <= index) throw new RuntimeException("Can't edit servers. Index exceeds size.");
            return setNewServerLike(index, buildServer(index));
    }

    public DNSSpecFluent.ServersNested<A> editFirstServer(){
            if (servers.size() == 0) throw new RuntimeException("Can't edit first servers. The list is empty.");
            return setNewServerLike(0, buildServer(0));
    }

    public DNSSpecFluent.ServersNested<A> editLastServer(){
            int index = servers.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last servers. The list is empty.");
            return setNewServerLike(index, buildServer(index));
    }

    public DNSSpecFluent.ServersNested<A> editMatchingServer(io.fabric8.kubernetes.api.builder.Predicate<ServerBuilder> predicate){
            int index = -1;
            for (int i=0;i<servers.size();i++) { 
            if (predicate.apply(servers.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching servers. No match found.");
            return setNewServerLike(index, buildServer(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            DNSSpecFluentImpl that = (DNSSpecFluentImpl) o;
            if (servers != null ? !servers.equals(that.servers) :that.servers != null) return false;
            return true;
    }


    public class ServersNestedImpl<N> extends ServerFluentImpl<DNSSpecFluent.ServersNested<N>> implements DNSSpecFluent.ServersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ServerBuilder builder;
        private final int index;
    
            ServersNestedImpl(int index,Server item){
                    this.index = index;
                    this.builder = new ServerBuilder(this, item);
            }
            ServersNestedImpl(){
                    this.index = -1;
                    this.builder = new ServerBuilder(this);
            }
    
    public N and(){
            return (N) DNSSpecFluentImpl.this.setToServers(index,builder.build());
    }
    public N endServer(){
            return and();
    }

}


}
