package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface DNSRecordListFluent<A extends DNSRecordListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,DNSRecord item);
    public A setToItems(int index,DNSRecord item);
    public A addToItems(DNSRecord... items);
    public A addAllToItems(Collection<DNSRecord> items);
    public A removeFromItems(DNSRecord... items);
    public A removeAllFromItems(Collection<DNSRecord> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<DNSRecordBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<DNSRecord> getItems();
    public List<DNSRecord> buildItems();
    public DNSRecord buildItem(int index);
    public DNSRecord buildFirstItem();
    public DNSRecord buildLastItem();
    public DNSRecord buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<DNSRecordBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<DNSRecordBuilder> predicate);
    public A withItems(List<DNSRecord> items);
    public A withItems(DNSRecord... items);
    public Boolean hasItems();
    public DNSRecordListFluent.ItemsNested<A> addNewItem();
    public DNSRecordListFluent.ItemsNested<A> addNewItemLike(DNSRecord item);
    public DNSRecordListFluent.ItemsNested<A> setNewItemLike(int index,DNSRecord item);
    public DNSRecordListFluent.ItemsNested<A> editItem(int index);
    public DNSRecordListFluent.ItemsNested<A> editFirstItem();
    public DNSRecordListFluent.ItemsNested<A> editLastItem();
    public DNSRecordListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<DNSRecordBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSRecordFluent<DNSRecordListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
