package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerLoggingDestinationParametersBuilder extends ContainerLoggingDestinationParametersFluentImpl<ContainerLoggingDestinationParametersBuilder> implements VisitableBuilder<ContainerLoggingDestinationParameters,ContainerLoggingDestinationParametersBuilder>{

    ContainerLoggingDestinationParametersFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerLoggingDestinationParametersBuilder(){
            this(true);
    }
    public ContainerLoggingDestinationParametersBuilder(Boolean validationEnabled){
            this(new ContainerLoggingDestinationParameters(), validationEnabled);
    }
    public ContainerLoggingDestinationParametersBuilder(ContainerLoggingDestinationParametersFluent<?> fluent){
            this(fluent, true);
    }
    public ContainerLoggingDestinationParametersBuilder(ContainerLoggingDestinationParametersFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ContainerLoggingDestinationParameters(), validationEnabled);
    }
    public ContainerLoggingDestinationParametersBuilder(ContainerLoggingDestinationParametersFluent<?> fluent,ContainerLoggingDestinationParameters instance){
            this(fluent, instance, true);
    }
    public ContainerLoggingDestinationParametersBuilder(ContainerLoggingDestinationParametersFluent<?> fluent,ContainerLoggingDestinationParameters instance,Boolean validationEnabled){
            this.fluent = fluent; 
            this.validationEnabled = validationEnabled; 
    }
    public ContainerLoggingDestinationParametersBuilder(ContainerLoggingDestinationParameters instance){
            this(instance,true);
    }
    public ContainerLoggingDestinationParametersBuilder(ContainerLoggingDestinationParameters instance,Boolean validationEnabled){
            this.fluent = this; 
            this.validationEnabled = validationEnabled; 
    }

    public ContainerLoggingDestinationParameters build(){
            ContainerLoggingDestinationParameters buildable = new ContainerLoggingDestinationParameters();
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerLoggingDestinationParametersBuilder that = (ContainerLoggingDestinationParametersBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
