package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ConsoleFluent<A extends ConsoleFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ConsoleFluent.MetadataNested<A> withNewMetadata();
    public ConsoleFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ConsoleFluent.MetadataNested<A> editMetadata();
    public ConsoleFluent.MetadataNested<A> editOrNewMetadata();
    public ConsoleFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ConsoleSpec getSpec();
    public ConsoleSpec buildSpec();
    public A withSpec(ConsoleSpec spec);
    public Boolean hasSpec();
    public ConsoleFluent.SpecNested<A> withNewSpec();
    public ConsoleFluent.SpecNested<A> withNewSpecLike(ConsoleSpec item);
    public ConsoleFluent.SpecNested<A> editSpec();
    public ConsoleFluent.SpecNested<A> editOrNewSpec();
    public ConsoleFluent.SpecNested<A> editOrNewSpecLike(ConsoleSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public ConsoleStatus getStatus();
    public ConsoleStatus buildStatus();
    public A withStatus(ConsoleStatus status);
    public Boolean hasStatus();
    public ConsoleFluent.StatusNested<A> withNewStatus();
    public ConsoleFluent.StatusNested<A> withNewStatusLike(ConsoleStatus item);
    public ConsoleFluent.StatusNested<A> editStatus();
    public ConsoleFluent.StatusNested<A> editOrNewStatus();
    public ConsoleFluent.StatusNested<A> editOrNewStatusLike(ConsoleStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ConsoleFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConsoleSpecFluent<ConsoleFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConsoleStatusFluent<ConsoleFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
