package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleCustomizationBuilder extends ConsoleCustomizationFluentImpl<ConsoleCustomizationBuilder> implements VisitableBuilder<ConsoleCustomization,ConsoleCustomizationBuilder>{

    ConsoleCustomizationFluent<?> fluent;
    Boolean validationEnabled;

    public ConsoleCustomizationBuilder(){
            this(true);
    }
    public ConsoleCustomizationBuilder(Boolean validationEnabled){
            this(new ConsoleCustomization(), validationEnabled);
    }
    public ConsoleCustomizationBuilder(ConsoleCustomizationFluent<?> fluent){
            this(fluent, true);
    }
    public ConsoleCustomizationBuilder(ConsoleCustomizationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ConsoleCustomization(), validationEnabled);
    }
    public ConsoleCustomizationBuilder(ConsoleCustomizationFluent<?> fluent,ConsoleCustomization instance){
            this(fluent, instance, true);
    }
    public ConsoleCustomizationBuilder(ConsoleCustomizationFluent<?> fluent,ConsoleCustomization instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBrand(instance.getBrand()); 
            fluent.withCustomLogoFile(instance.getCustomLogoFile()); 
            fluent.withCustomProductName(instance.getCustomProductName()); 
            fluent.withDocumentationBaseURL(instance.getDocumentationBaseURL()); 
            this.validationEnabled = validationEnabled; 
    }
    public ConsoleCustomizationBuilder(ConsoleCustomization instance){
            this(instance,true);
    }
    public ConsoleCustomizationBuilder(ConsoleCustomization instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBrand(instance.getBrand()); 
            this.withCustomLogoFile(instance.getCustomLogoFile()); 
            this.withCustomProductName(instance.getCustomProductName()); 
            this.withDocumentationBaseURL(instance.getDocumentationBaseURL()); 
            this.validationEnabled = validationEnabled; 
    }

    public ConsoleCustomization build(){
            ConsoleCustomization buildable = new ConsoleCustomization(fluent.getBrand(),fluent.getCustomLogoFile(),fluent.getCustomProductName(),fluent.getDocumentationBaseURL());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConsoleCustomizationBuilder that = (ConsoleCustomizationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
