package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AccessLoggingBuilder extends AccessLoggingFluentImpl<AccessLoggingBuilder> implements VisitableBuilder<AccessLogging,AccessLoggingBuilder>{

    AccessLoggingFluent<?> fluent;
    Boolean validationEnabled;

    public AccessLoggingBuilder(){
            this(true);
    }
    public AccessLoggingBuilder(Boolean validationEnabled){
            this(new AccessLogging(), validationEnabled);
    }
    public AccessLoggingBuilder(AccessLoggingFluent<?> fluent){
            this(fluent, true);
    }
    public AccessLoggingBuilder(AccessLoggingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AccessLogging(), validationEnabled);
    }
    public AccessLoggingBuilder(AccessLoggingFluent<?> fluent,AccessLogging instance){
            this(fluent, instance, true);
    }
    public AccessLoggingBuilder(AccessLoggingFluent<?> fluent,AccessLogging instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDestination(instance.getDestination()); 
            fluent.withHttpCaptureCookies(instance.getHttpCaptureCookies()); 
            fluent.withHttpCaptureHeaders(instance.getHttpCaptureHeaders()); 
            fluent.withHttpLogFormat(instance.getHttpLogFormat()); 
            this.validationEnabled = validationEnabled; 
    }
    public AccessLoggingBuilder(AccessLogging instance){
            this(instance,true);
    }
    public AccessLoggingBuilder(AccessLogging instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDestination(instance.getDestination()); 
            this.withHttpCaptureCookies(instance.getHttpCaptureCookies()); 
            this.withHttpCaptureHeaders(instance.getHttpCaptureHeaders()); 
            this.withHttpLogFormat(instance.getHttpLogFormat()); 
            this.validationEnabled = validationEnabled; 
    }

    public AccessLogging build(){
            AccessLogging buildable = new AccessLogging(fluent.getDestination(),fluent.getHttpCaptureCookies(),fluent.getHttpCaptureHeaders(),fluent.getHttpLogFormat());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AccessLoggingBuilder that = (AccessLoggingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
