package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ModernTLSProfileBuilder extends ModernTLSProfileFluentImpl<ModernTLSProfileBuilder> implements VisitableBuilder<ModernTLSProfile,ModernTLSProfileBuilder>{

    ModernTLSProfileFluent<?> fluent;
    Boolean validationEnabled;

    public ModernTLSProfileBuilder(){
            this(true);
    }
    public ModernTLSProfileBuilder(Boolean validationEnabled){
            this(new ModernTLSProfile(), validationEnabled);
    }
    public ModernTLSProfileBuilder(ModernTLSProfileFluent<?> fluent){
            this(fluent, true);
    }
    public ModernTLSProfileBuilder(ModernTLSProfileFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ModernTLSProfile(), validationEnabled);
    }
    public ModernTLSProfileBuilder(ModernTLSProfileFluent<?> fluent,ModernTLSProfile instance){
            this(fluent, instance, true);
    }
    public ModernTLSProfileBuilder(ModernTLSProfileFluent<?> fluent,ModernTLSProfile instance,Boolean validationEnabled){
            this.fluent = fluent; 
            this.validationEnabled = validationEnabled; 
    }
    public ModernTLSProfileBuilder(ModernTLSProfile instance){
            this(instance,true);
    }
    public ModernTLSProfileBuilder(ModernTLSProfile instance,Boolean validationEnabled){
            this.fluent = this; 
            this.validationEnabled = validationEnabled; 
    }

    public ModernTLSProfile build(){
            ModernTLSProfile buildable = new ModernTLSProfile();
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ModernTLSProfileBuilder that = (ModernTLSProfileBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
