package io.fabric8.openshift.api.model.operator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RepositoryDigestMirrorsBuilder extends RepositoryDigestMirrorsFluentImpl<RepositoryDigestMirrorsBuilder> implements VisitableBuilder<RepositoryDigestMirrors,RepositoryDigestMirrorsBuilder>{

    RepositoryDigestMirrorsFluent<?> fluent;
    Boolean validationEnabled;

    public RepositoryDigestMirrorsBuilder(){
            this(true);
    }
    public RepositoryDigestMirrorsBuilder(Boolean validationEnabled){
            this(new RepositoryDigestMirrors(), validationEnabled);
    }
    public RepositoryDigestMirrorsBuilder(RepositoryDigestMirrorsFluent<?> fluent){
            this(fluent, true);
    }
    public RepositoryDigestMirrorsBuilder(RepositoryDigestMirrorsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RepositoryDigestMirrors(), validationEnabled);
    }
    public RepositoryDigestMirrorsBuilder(RepositoryDigestMirrorsFluent<?> fluent,RepositoryDigestMirrors instance){
            this(fluent, instance, true);
    }
    public RepositoryDigestMirrorsBuilder(RepositoryDigestMirrorsFluent<?> fluent,RepositoryDigestMirrors instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMirrors(instance.getMirrors()); 
            fluent.withSource(instance.getSource()); 
            this.validationEnabled = validationEnabled; 
    }
    public RepositoryDigestMirrorsBuilder(RepositoryDigestMirrors instance){
            this(instance,true);
    }
    public RepositoryDigestMirrorsBuilder(RepositoryDigestMirrors instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMirrors(instance.getMirrors()); 
            this.withSource(instance.getSource()); 
            this.validationEnabled = validationEnabled; 
    }

    public RepositoryDigestMirrors build(){
            RepositoryDigestMirrors buildable = new RepositoryDigestMirrors(fluent.getMirrors(),fluent.getSource());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RepositoryDigestMirrorsBuilder that = (RepositoryDigestMirrorsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
