package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StaticIPAMConfigBuilder extends StaticIPAMConfigFluentImpl<StaticIPAMConfigBuilder> implements VisitableBuilder<StaticIPAMConfig,StaticIPAMConfigBuilder>{

    StaticIPAMConfigFluent<?> fluent;
    Boolean validationEnabled;

    public StaticIPAMConfigBuilder(){
            this(true);
    }
    public StaticIPAMConfigBuilder(Boolean validationEnabled){
            this(new StaticIPAMConfig(), validationEnabled);
    }
    public StaticIPAMConfigBuilder(StaticIPAMConfigFluent<?> fluent){
            this(fluent, true);
    }
    public StaticIPAMConfigBuilder(StaticIPAMConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new StaticIPAMConfig(), validationEnabled);
    }
    public StaticIPAMConfigBuilder(StaticIPAMConfigFluent<?> fluent,StaticIPAMConfig instance){
            this(fluent, instance, true);
    }
    public StaticIPAMConfigBuilder(StaticIPAMConfigFluent<?> fluent,StaticIPAMConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddresses(instance.getAddresses()); 
            fluent.withDns(instance.getDns()); 
            fluent.withRoutes(instance.getRoutes()); 
            this.validationEnabled = validationEnabled; 
    }
    public StaticIPAMConfigBuilder(StaticIPAMConfig instance){
            this(instance,true);
    }
    public StaticIPAMConfigBuilder(StaticIPAMConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddresses(instance.getAddresses()); 
            this.withDns(instance.getDns()); 
            this.withRoutes(instance.getRoutes()); 
            this.validationEnabled = validationEnabled; 
    }

    public StaticIPAMConfig build(){
            StaticIPAMConfig buildable = new StaticIPAMConfig(fluent.getAddresses(),fluent.getDns(),fluent.getRoutes());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StaticIPAMConfigBuilder that = (StaticIPAMConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
