package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ServiceCatalogControllerManagerListFluent<A extends ServiceCatalogControllerManagerListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,ServiceCatalogControllerManager item);
    public A setToItems(int index,ServiceCatalogControllerManager item);
    public A addToItems(ServiceCatalogControllerManager... items);
    public A addAllToItems(Collection<ServiceCatalogControllerManager> items);
    public A removeFromItems(ServiceCatalogControllerManager... items);
    public A removeAllFromItems(Collection<ServiceCatalogControllerManager> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<ServiceCatalogControllerManagerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ServiceCatalogControllerManager> getItems();
    public List<ServiceCatalogControllerManager> buildItems();
    public ServiceCatalogControllerManager buildItem(int index);
    public ServiceCatalogControllerManager buildFirstItem();
    public ServiceCatalogControllerManager buildLastItem();
    public ServiceCatalogControllerManager buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ServiceCatalogControllerManagerBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ServiceCatalogControllerManagerBuilder> predicate);
    public A withItems(List<ServiceCatalogControllerManager> items);
    public A withItems(ServiceCatalogControllerManager... items);
    public Boolean hasItems();
    public ServiceCatalogControllerManagerListFluent.ItemsNested<A> addNewItem();
    public ServiceCatalogControllerManagerListFluent.ItemsNested<A> addNewItemLike(ServiceCatalogControllerManager item);
    public ServiceCatalogControllerManagerListFluent.ItemsNested<A> setNewItemLike(int index,ServiceCatalogControllerManager item);
    public ServiceCatalogControllerManagerListFluent.ItemsNested<A> editItem(int index);
    public ServiceCatalogControllerManagerListFluent.ItemsNested<A> editFirstItem();
    public ServiceCatalogControllerManagerListFluent.ItemsNested<A> editLastItem();
    public ServiceCatalogControllerManagerListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ServiceCatalogControllerManagerBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogControllerManagerFluent<ServiceCatalogControllerManagerListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
