package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceCatalogControllerManagerListBuilder extends ServiceCatalogControllerManagerListFluentImpl<ServiceCatalogControllerManagerListBuilder> implements VisitableBuilder<ServiceCatalogControllerManagerList,ServiceCatalogControllerManagerListBuilder>{

    ServiceCatalogControllerManagerListFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceCatalogControllerManagerListBuilder(){
            this(true);
    }
    public ServiceCatalogControllerManagerListBuilder(Boolean validationEnabled){
            this(new ServiceCatalogControllerManagerList(), validationEnabled);
    }
    public ServiceCatalogControllerManagerListBuilder(ServiceCatalogControllerManagerListFluent<?> fluent){
            this(fluent, true);
    }
    public ServiceCatalogControllerManagerListBuilder(ServiceCatalogControllerManagerListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServiceCatalogControllerManagerList(), validationEnabled);
    }
    public ServiceCatalogControllerManagerListBuilder(ServiceCatalogControllerManagerListFluent<?> fluent,ServiceCatalogControllerManagerList instance){
            this(fluent, instance, true);
    }
    public ServiceCatalogControllerManagerListBuilder(ServiceCatalogControllerManagerListFluent<?> fluent,ServiceCatalogControllerManagerList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceCatalogControllerManagerListBuilder(ServiceCatalogControllerManagerList instance){
            this(instance,true);
    }
    public ServiceCatalogControllerManagerListBuilder(ServiceCatalogControllerManagerList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public ServiceCatalogControllerManagerList build(){
            ServiceCatalogControllerManagerList buildable = new ServiceCatalogControllerManagerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceCatalogControllerManagerListBuilder that = (ServiceCatalogControllerManagerListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
