package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ServiceCatalogControllerManagerFluent<A extends ServiceCatalogControllerManagerFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ServiceCatalogControllerManagerFluent.MetadataNested<A> withNewMetadata();
    public ServiceCatalogControllerManagerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ServiceCatalogControllerManagerFluent.MetadataNested<A> editMetadata();
    public ServiceCatalogControllerManagerFluent.MetadataNested<A> editOrNewMetadata();
    public ServiceCatalogControllerManagerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ServiceCatalogControllerManagerSpec getSpec();
    public ServiceCatalogControllerManagerSpec buildSpec();
    public A withSpec(ServiceCatalogControllerManagerSpec spec);
    public Boolean hasSpec();
    public ServiceCatalogControllerManagerFluent.SpecNested<A> withNewSpec();
    public ServiceCatalogControllerManagerFluent.SpecNested<A> withNewSpecLike(ServiceCatalogControllerManagerSpec item);
    public ServiceCatalogControllerManagerFluent.SpecNested<A> editSpec();
    public ServiceCatalogControllerManagerFluent.SpecNested<A> editOrNewSpec();
    public ServiceCatalogControllerManagerFluent.SpecNested<A> editOrNewSpecLike(ServiceCatalogControllerManagerSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public ServiceCatalogControllerManagerStatus getStatus();
    public ServiceCatalogControllerManagerStatus buildStatus();
    public A withStatus(ServiceCatalogControllerManagerStatus status);
    public Boolean hasStatus();
    public ServiceCatalogControllerManagerFluent.StatusNested<A> withNewStatus();
    public ServiceCatalogControllerManagerFluent.StatusNested<A> withNewStatusLike(ServiceCatalogControllerManagerStatus item);
    public ServiceCatalogControllerManagerFluent.StatusNested<A> editStatus();
    public ServiceCatalogControllerManagerFluent.StatusNested<A> editOrNewStatus();
    public ServiceCatalogControllerManagerFluent.StatusNested<A> editOrNewStatusLike(ServiceCatalogControllerManagerStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ServiceCatalogControllerManagerFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogControllerManagerSpecFluent<ServiceCatalogControllerManagerFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogControllerManagerStatusFluent<ServiceCatalogControllerManagerFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
