package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceCatalogAPIServerBuilder extends ServiceCatalogAPIServerFluentImpl<ServiceCatalogAPIServerBuilder> implements VisitableBuilder<ServiceCatalogAPIServer,ServiceCatalogAPIServerBuilder>{

    ServiceCatalogAPIServerFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceCatalogAPIServerBuilder(){
            this(true);
    }
    public ServiceCatalogAPIServerBuilder(Boolean validationEnabled){
            this(new ServiceCatalogAPIServer(), validationEnabled);
    }
    public ServiceCatalogAPIServerBuilder(ServiceCatalogAPIServerFluent<?> fluent){
            this(fluent, true);
    }
    public ServiceCatalogAPIServerBuilder(ServiceCatalogAPIServerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServiceCatalogAPIServer(), validationEnabled);
    }
    public ServiceCatalogAPIServerBuilder(ServiceCatalogAPIServerFluent<?> fluent,ServiceCatalogAPIServer instance){
            this(fluent, instance, true);
    }
    public ServiceCatalogAPIServerBuilder(ServiceCatalogAPIServerFluent<?> fluent,ServiceCatalogAPIServer instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceCatalogAPIServerBuilder(ServiceCatalogAPIServer instance){
            this(instance,true);
    }
    public ServiceCatalogAPIServerBuilder(ServiceCatalogAPIServer instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public ServiceCatalogAPIServer build(){
            ServiceCatalogAPIServer buildable = new ServiceCatalogAPIServer(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceCatalogAPIServerBuilder that = (ServiceCatalogAPIServerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
