package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceCASpecBuilder extends ServiceCASpecFluentImpl<ServiceCASpecBuilder> implements VisitableBuilder<ServiceCASpec,ServiceCASpecBuilder>{

    ServiceCASpecFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceCASpecBuilder(){
            this(true);
    }
    public ServiceCASpecBuilder(Boolean validationEnabled){
            this(new ServiceCASpec(), validationEnabled);
    }
    public ServiceCASpecBuilder(ServiceCASpecFluent<?> fluent){
            this(fluent, true);
    }
    public ServiceCASpecBuilder(ServiceCASpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServiceCASpec(), validationEnabled);
    }
    public ServiceCASpecBuilder(ServiceCASpecFluent<?> fluent,ServiceCASpec instance){
            this(fluent, instance, true);
    }
    public ServiceCASpecBuilder(ServiceCASpecFluent<?> fluent,ServiceCASpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLogLevel(instance.getLogLevel()); 
            fluent.withManagementState(instance.getManagementState()); 
            fluent.withObservedConfig(instance.getObservedConfig()); 
            fluent.withOperatorLogLevel(instance.getOperatorLogLevel()); 
            fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceCASpecBuilder(ServiceCASpec instance){
            this(instance,true);
    }
    public ServiceCASpecBuilder(ServiceCASpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLogLevel(instance.getLogLevel()); 
            this.withManagementState(instance.getManagementState()); 
            this.withObservedConfig(instance.getObservedConfig()); 
            this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
            this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
            this.validationEnabled = validationEnabled; 
    }

    public ServiceCASpec build(){
            ServiceCASpec buildable = new ServiceCASpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getUnsupportedConfigOverrides());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceCASpecBuilder that = (ServiceCASpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
