package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ProxyConfigBuilder extends ProxyConfigFluentImpl<ProxyConfigBuilder> implements VisitableBuilder<ProxyConfig,ProxyConfigBuilder>{

    ProxyConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ProxyConfigBuilder(){
            this(true);
    }
    public ProxyConfigBuilder(Boolean validationEnabled){
            this(new ProxyConfig(), validationEnabled);
    }
    public ProxyConfigBuilder(ProxyConfigFluent<?> fluent){
            this(fluent, true);
    }
    public ProxyConfigBuilder(ProxyConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ProxyConfig(), validationEnabled);
    }
    public ProxyConfigBuilder(ProxyConfigFluent<?> fluent,ProxyConfig instance){
            this(fluent, instance, true);
    }
    public ProxyConfigBuilder(ProxyConfigFluent<?> fluent,ProxyConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBindAddress(instance.getBindAddress()); 
            fluent.withIptablesSyncPeriod(instance.getIptablesSyncPeriod()); 
            fluent.withProxyArguments(instance.getProxyArguments()); 
            this.validationEnabled = validationEnabled; 
    }
    public ProxyConfigBuilder(ProxyConfig instance){
            this(instance,true);
    }
    public ProxyConfigBuilder(ProxyConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBindAddress(instance.getBindAddress()); 
            this.withIptablesSyncPeriod(instance.getIptablesSyncPeriod()); 
            this.withProxyArguments(instance.getProxyArguments()); 
            this.validationEnabled = validationEnabled; 
    }

    public ProxyConfig build(){
            ProxyConfig buildable = new ProxyConfig(fluent.getBindAddress(),fluent.getIptablesSyncPeriod(),fluent.getProxyArguments());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ProxyConfigBuilder that = (ProxyConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
