package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder;

public interface OpenShiftAPIServerSpecFluent<A extends OpenShiftAPIServerSpecFluent<A>> extends Fluent<A>{


    public String getLogLevel();
    public A withLogLevel(String logLevel);
    public Boolean hasLogLevel();
    public A withNewLogLevel(String arg1);
    public A withNewLogLevel(StringBuilder arg1);
    public A withNewLogLevel(StringBuffer arg1);
    public String getManagementState();
    public A withManagementState(String managementState);
    public Boolean hasManagementState();
    public A withNewManagementState(String arg1);
    public A withNewManagementState(StringBuilder arg1);
    public A withNewManagementState(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildObservedConfig instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getObservedConfig();
    public HasMetadata buildObservedConfig();
    public A withObservedConfig(HasMetadata observedConfig);
    public Boolean hasObservedConfig();
    public A withImagePrunerObservedConfig(ImagePruner imagePrunerObservedConfig);
    public OpenShiftAPIServerSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfig();
    public OpenShiftAPIServerSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfigLike(ImagePruner item);
    public A withKubeControllerManagerObservedConfig(KubeControllerManager kubeControllerManagerObservedConfig);
    public OpenShiftAPIServerSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfig();
    public OpenShiftAPIServerSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfigLike(KubeControllerManager item);
    public A withImageContentSourcePolicyObservedConfig(ImageContentSourcePolicy imageContentSourcePolicyObservedConfig);
    public OpenShiftAPIServerSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfig();
    public OpenShiftAPIServerSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfigLike(ImageContentSourcePolicy item);
    public A withServiceCAObservedConfig(ServiceCA serviceCAObservedConfig);
    public OpenShiftAPIServerSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfig();
    public OpenShiftAPIServerSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfigLike(ServiceCA item);
    public A withPersistentVolumeClaimObservedConfig(PersistentVolumeClaim persistentVolumeClaimObservedConfig);
    public OpenShiftAPIServerSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfig();
    public OpenShiftAPIServerSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfigLike(PersistentVolumeClaim item);
    public A withKubeAPIServerObservedConfig(KubeAPIServer kubeAPIServerObservedConfig);
    public OpenShiftAPIServerSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfig();
    public OpenShiftAPIServerSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfigLike(KubeAPIServer item);
    public A withIngressControllerObservedConfig(IngressController ingressControllerObservedConfig);
    public OpenShiftAPIServerSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfig();
    public OpenShiftAPIServerSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfigLike(IngressController item);
    public A withKubeStorageVersionMigratorObservedConfig(KubeStorageVersionMigrator kubeStorageVersionMigratorObservedConfig);
    public OpenShiftAPIServerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfig();
    public OpenShiftAPIServerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfigLike(KubeStorageVersionMigrator item);
    public A withConsoleObservedConfig(Console consoleObservedConfig);
    public OpenShiftAPIServerSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfig();
    public OpenShiftAPIServerSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfigLike(Console item);
    public A withOpenShiftControllerManagerObservedConfig(OpenShiftControllerManager openShiftControllerManagerObservedConfig);
    public OpenShiftAPIServerSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfig();
    public OpenShiftAPIServerSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfigLike(OpenShiftControllerManager item);
    public A withEtcdObservedConfig(Etcd etcdObservedConfig);
    public OpenShiftAPIServerSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfig();
    public OpenShiftAPIServerSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfigLike(Etcd item);
    public A withKubeSchedulerObservedConfig(KubeScheduler kubeSchedulerObservedConfig);
    public OpenShiftAPIServerSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfig();
    public OpenShiftAPIServerSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfigLike(KubeScheduler item);
    public A withNetworkObservedConfig(Network networkObservedConfig);
    public OpenShiftAPIServerSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfig();
    public OpenShiftAPIServerSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfigLike(Network item);
    public A withServiceCatalogAPIServerObservedConfig(ServiceCatalogAPIServer serviceCatalogAPIServerObservedConfig);
    public OpenShiftAPIServerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfig();
    public OpenShiftAPIServerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfigLike(ServiceCatalogAPIServer item);
    public A withCSISnapshotControllerObservedConfig(CSISnapshotController cSISnapshotControllerObservedConfig);
    public OpenShiftAPIServerSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfig();
    public OpenShiftAPIServerSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfigLike(CSISnapshotController item);
    public A withServiceCatalogControllerManagerObservedConfig(ServiceCatalogControllerManager serviceCatalogControllerManagerObservedConfig);
    public OpenShiftAPIServerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfig();
    public OpenShiftAPIServerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfigLike(ServiceCatalogControllerManager item);
    public A withDNSObservedConfig(DNS dNSObservedConfig);
    public OpenShiftAPIServerSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfig();
    public OpenShiftAPIServerSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfigLike(DNS item);
    public A withDNSRecordObservedConfig(DNSRecord dNSRecordObservedConfig);
    public OpenShiftAPIServerSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfig();
    public OpenShiftAPIServerSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfigLike(DNSRecord item);
    public A withOpenShiftAPIServerObservedConfig(OpenShiftAPIServer openShiftAPIServerObservedConfig);
    public OpenShiftAPIServerSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfig();
    public OpenShiftAPIServerSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfigLike(OpenShiftAPIServer item);
    public A withAuthenticationObservedConfig(Authentication authenticationObservedConfig);
    public OpenShiftAPIServerSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfig();
    public OpenShiftAPIServerSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfigLike(Authentication item);
    public String getOperatorLogLevel();
    public A withOperatorLogLevel(String operatorLogLevel);
    public Boolean hasOperatorLogLevel();
    public A withNewOperatorLogLevel(String arg1);
    public A withNewOperatorLogLevel(StringBuilder arg1);
    public A withNewOperatorLogLevel(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildUnsupportedConfigOverrides instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getUnsupportedConfigOverrides();
    public HasMetadata buildUnsupportedConfigOverrides();
    public A withUnsupportedConfigOverrides(HasMetadata unsupportedConfigOverrides);
    public Boolean hasUnsupportedConfigOverrides();
    public A withImagePrunerUnsupportedConfigOverrides(ImagePruner imagePrunerUnsupportedConfigOverrides);
    public OpenShiftAPIServerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverrides();
    public OpenShiftAPIServerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverridesLike(ImagePruner item);
    public A withKubeControllerManagerUnsupportedConfigOverrides(KubeControllerManager kubeControllerManagerUnsupportedConfigOverrides);
    public OpenShiftAPIServerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverrides();
    public OpenShiftAPIServerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverridesLike(KubeControllerManager item);
    public A withImageContentSourcePolicyUnsupportedConfigOverrides(ImageContentSourcePolicy imageContentSourcePolicyUnsupportedConfigOverrides);
    public OpenShiftAPIServerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverrides();
    public OpenShiftAPIServerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverridesLike(ImageContentSourcePolicy item);
    public A withServiceCAUnsupportedConfigOverrides(ServiceCA serviceCAUnsupportedConfigOverrides);
    public OpenShiftAPIServerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverrides();
    public OpenShiftAPIServerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverridesLike(ServiceCA item);
    public A withPersistentVolumeClaimUnsupportedConfigOverrides(PersistentVolumeClaim persistentVolumeClaimUnsupportedConfigOverrides);
    public OpenShiftAPIServerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverrides();
    public OpenShiftAPIServerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverridesLike(PersistentVolumeClaim item);
    public A withKubeAPIServerUnsupportedConfigOverrides(KubeAPIServer kubeAPIServerUnsupportedConfigOverrides);
    public OpenShiftAPIServerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverrides();
    public OpenShiftAPIServerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverridesLike(KubeAPIServer item);
    public A withIngressControllerUnsupportedConfigOverrides(IngressController ingressControllerUnsupportedConfigOverrides);
    public OpenShiftAPIServerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverrides();
    public OpenShiftAPIServerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverridesLike(IngressController item);
    public A withKubeStorageVersionMigratorUnsupportedConfigOverrides(KubeStorageVersionMigrator kubeStorageVersionMigratorUnsupportedConfigOverrides);
    public OpenShiftAPIServerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverrides();
    public OpenShiftAPIServerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverridesLike(KubeStorageVersionMigrator item);
    public A withConsoleUnsupportedConfigOverrides(Console consoleUnsupportedConfigOverrides);
    public OpenShiftAPIServerSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverrides();
    public OpenShiftAPIServerSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverridesLike(Console item);
    public A withOpenShiftControllerManagerUnsupportedConfigOverrides(OpenShiftControllerManager openShiftControllerManagerUnsupportedConfigOverrides);
    public OpenShiftAPIServerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverrides();
    public OpenShiftAPIServerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverridesLike(OpenShiftControllerManager item);
    public A withEtcdUnsupportedConfigOverrides(Etcd etcdUnsupportedConfigOverrides);
    public OpenShiftAPIServerSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverrides();
    public OpenShiftAPIServerSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverridesLike(Etcd item);
    public A withKubeSchedulerUnsupportedConfigOverrides(KubeScheduler kubeSchedulerUnsupportedConfigOverrides);
    public OpenShiftAPIServerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverrides();
    public OpenShiftAPIServerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverridesLike(KubeScheduler item);
    public A withNetworkUnsupportedConfigOverrides(Network networkUnsupportedConfigOverrides);
    public OpenShiftAPIServerSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverrides();
    public OpenShiftAPIServerSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverridesLike(Network item);
    public A withServiceCatalogAPIServerUnsupportedConfigOverrides(ServiceCatalogAPIServer serviceCatalogAPIServerUnsupportedConfigOverrides);
    public OpenShiftAPIServerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverrides();
    public OpenShiftAPIServerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverridesLike(ServiceCatalogAPIServer item);
    public A withCSISnapshotControllerUnsupportedConfigOverrides(CSISnapshotController cSISnapshotControllerUnsupportedConfigOverrides);
    public OpenShiftAPIServerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverrides();
    public OpenShiftAPIServerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverridesLike(CSISnapshotController item);
    public A withServiceCatalogControllerManagerUnsupportedConfigOverrides(ServiceCatalogControllerManager serviceCatalogControllerManagerUnsupportedConfigOverrides);
    public OpenShiftAPIServerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverrides();
    public OpenShiftAPIServerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverridesLike(ServiceCatalogControllerManager item);
    public A withDNSUnsupportedConfigOverrides(DNS dNSUnsupportedConfigOverrides);
    public OpenShiftAPIServerSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverrides();
    public OpenShiftAPIServerSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverridesLike(DNS item);
    public A withDNSRecordUnsupportedConfigOverrides(DNSRecord dNSRecordUnsupportedConfigOverrides);
    public OpenShiftAPIServerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverrides();
    public OpenShiftAPIServerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverridesLike(DNSRecord item);
    public A withOpenShiftAPIServerUnsupportedConfigOverrides(OpenShiftAPIServer openShiftAPIServerUnsupportedConfigOverrides);
    public OpenShiftAPIServerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverrides();
    public OpenShiftAPIServerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverridesLike(OpenShiftAPIServer item);
    public A withAuthenticationUnsupportedConfigOverrides(Authentication authenticationUnsupportedConfigOverrides);
    public OpenShiftAPIServerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverrides();
    public OpenShiftAPIServerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverridesLike(Authentication item);

    public interface ImagePrunerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImagePrunerFluent<OpenShiftAPIServerSpecFluent.ImagePrunerObservedConfigNested<N>>{

        
    public N and();    public N endImagePrunerObservedConfig();
}
    public interface KubeControllerManagerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeControllerManagerFluent<OpenShiftAPIServerSpecFluent.KubeControllerManagerObservedConfigNested<N>>{

        
    public N and();    public N endKubeControllerManagerObservedConfig();
}
    public interface ImageContentSourcePolicyObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageContentSourcePolicyFluent<OpenShiftAPIServerSpecFluent.ImageContentSourcePolicyObservedConfigNested<N>>{

        
    public N and();    public N endImageContentSourcePolicyObservedConfig();
}
    public interface ServiceCAObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCAFluent<OpenShiftAPIServerSpecFluent.ServiceCAObservedConfigNested<N>>{

        
    public N and();    public N endServiceCAObservedConfig();
}
    public interface PersistentVolumeClaimObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<OpenShiftAPIServerSpecFluent.PersistentVolumeClaimObservedConfigNested<N>>{

        
    public N and();    public N endPersistentVolumeClaimObservedConfig();
}
    public interface KubeAPIServerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeAPIServerFluent<OpenShiftAPIServerSpecFluent.KubeAPIServerObservedConfigNested<N>>{

        
    public N and();    public N endKubeAPIServerObservedConfig();
}
    public interface IngressControllerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressControllerFluent<OpenShiftAPIServerSpecFluent.IngressControllerObservedConfigNested<N>>{

        
    public N and();    public N endIngressControllerObservedConfig();
}
    public interface KubeStorageVersionMigratorObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeStorageVersionMigratorFluent<OpenShiftAPIServerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<N>>{

        
    public N and();    public N endKubeStorageVersionMigratorObservedConfig();
}
    public interface ConsoleObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConsoleFluent<OpenShiftAPIServerSpecFluent.ConsoleObservedConfigNested<N>>{

        
    public N and();    public N endConsoleObservedConfig();
}
    public interface OpenShiftControllerManagerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftControllerManagerFluent<OpenShiftAPIServerSpecFluent.OpenShiftControllerManagerObservedConfigNested<N>>{

        
    public N and();    public N endOpenShiftControllerManagerObservedConfig();
}
    public interface EtcdObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EtcdFluent<OpenShiftAPIServerSpecFluent.EtcdObservedConfigNested<N>>{

        
    public N and();    public N endEtcdObservedConfig();
}
    public interface KubeSchedulerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeSchedulerFluent<OpenShiftAPIServerSpecFluent.KubeSchedulerObservedConfigNested<N>>{

        
    public N and();    public N endKubeSchedulerObservedConfig();
}
    public interface NetworkObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetworkFluent<OpenShiftAPIServerSpecFluent.NetworkObservedConfigNested<N>>{

        
    public N and();    public N endNetworkObservedConfig();
}
    public interface ServiceCatalogAPIServerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogAPIServerFluent<OpenShiftAPIServerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<N>>{

        
    public N and();    public N endServiceCatalogAPIServerObservedConfig();
}
    public interface CSISnapshotControllerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CSISnapshotControllerFluent<OpenShiftAPIServerSpecFluent.CSISnapshotControllerObservedConfigNested<N>>{

        
    public N and();    public N endCSISnapshotControllerObservedConfig();
}
    public interface ServiceCatalogControllerManagerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogControllerManagerFluent<OpenShiftAPIServerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<N>>{

        
    public N and();    public N endServiceCatalogControllerManagerObservedConfig();
}
    public interface DNSObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSFluent<OpenShiftAPIServerSpecFluent.DNSObservedConfigNested<N>>{

        
    public N and();    public N endDNSObservedConfig();
}
    public interface DNSRecordObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSRecordFluent<OpenShiftAPIServerSpecFluent.DNSRecordObservedConfigNested<N>>{

        
    public N and();    public N endDNSRecordObservedConfig();
}
    public interface OpenShiftAPIServerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftAPIServerFluent<OpenShiftAPIServerSpecFluent.OpenShiftAPIServerObservedConfigNested<N>>{

        
    public N and();    public N endOpenShiftAPIServerObservedConfig();
}
    public interface AuthenticationObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AuthenticationFluent<OpenShiftAPIServerSpecFluent.AuthenticationObservedConfigNested<N>>{

        
    public N and();    public N endAuthenticationObservedConfig();
}
    public interface ImagePrunerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImagePrunerFluent<OpenShiftAPIServerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>>{

        
    public N and();    public N endImagePrunerUnsupportedConfigOverrides();
}
    public interface KubeControllerManagerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeControllerManagerFluent<OpenShiftAPIServerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>>{

        
    public N and();    public N endKubeControllerManagerUnsupportedConfigOverrides();
}
    public interface ImageContentSourcePolicyUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageContentSourcePolicyFluent<OpenShiftAPIServerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>>{

        
    public N and();    public N endImageContentSourcePolicyUnsupportedConfigOverrides();
}
    public interface ServiceCAUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCAFluent<OpenShiftAPIServerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>>{

        
    public N and();    public N endServiceCAUnsupportedConfigOverrides();
}
    public interface PersistentVolumeClaimUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<OpenShiftAPIServerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>>{

        
    public N and();    public N endPersistentVolumeClaimUnsupportedConfigOverrides();
}
    public interface KubeAPIServerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeAPIServerFluent<OpenShiftAPIServerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>>{

        
    public N and();    public N endKubeAPIServerUnsupportedConfigOverrides();
}
    public interface IngressControllerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressControllerFluent<OpenShiftAPIServerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>>{

        
    public N and();    public N endIngressControllerUnsupportedConfigOverrides();
}
    public interface KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeStorageVersionMigratorFluent<OpenShiftAPIServerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>>{

        
    public N and();    public N endKubeStorageVersionMigratorUnsupportedConfigOverrides();
}
    public interface ConsoleUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConsoleFluent<OpenShiftAPIServerSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>>{

        
    public N and();    public N endConsoleUnsupportedConfigOverrides();
}
    public interface OpenShiftControllerManagerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftControllerManagerFluent<OpenShiftAPIServerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>>{

        
    public N and();    public N endOpenShiftControllerManagerUnsupportedConfigOverrides();
}
    public interface EtcdUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EtcdFluent<OpenShiftAPIServerSpecFluent.EtcdUnsupportedConfigOverridesNested<N>>{

        
    public N and();    public N endEtcdUnsupportedConfigOverrides();
}
    public interface KubeSchedulerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeSchedulerFluent<OpenShiftAPIServerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>>{

        
    public N and();    public N endKubeSchedulerUnsupportedConfigOverrides();
}
    public interface NetworkUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetworkFluent<OpenShiftAPIServerSpecFluent.NetworkUnsupportedConfigOverridesNested<N>>{

        
    public N and();    public N endNetworkUnsupportedConfigOverrides();
}
    public interface ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogAPIServerFluent<OpenShiftAPIServerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>>{

        
    public N and();    public N endServiceCatalogAPIServerUnsupportedConfigOverrides();
}
    public interface CSISnapshotControllerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CSISnapshotControllerFluent<OpenShiftAPIServerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>>{

        
    public N and();    public N endCSISnapshotControllerUnsupportedConfigOverrides();
}
    public interface ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogControllerManagerFluent<OpenShiftAPIServerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>>{

        
    public N and();    public N endServiceCatalogControllerManagerUnsupportedConfigOverrides();
}
    public interface DNSUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSFluent<OpenShiftAPIServerSpecFluent.DNSUnsupportedConfigOverridesNested<N>>{

        
    public N and();    public N endDNSUnsupportedConfigOverrides();
}
    public interface DNSRecordUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSRecordFluent<OpenShiftAPIServerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>>{

        
    public N and();    public N endDNSRecordUnsupportedConfigOverrides();
}
    public interface OpenShiftAPIServerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftAPIServerFluent<OpenShiftAPIServerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>>{

        
    public N and();    public N endOpenShiftAPIServerUnsupportedConfigOverrides();
}
    public interface AuthenticationUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AuthenticationFluent<OpenShiftAPIServerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>>{

        
    public N and();    public N endAuthenticationUnsupportedConfigOverrides();
}


}
